/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.FormatReadSettings;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class GetMetadataActivityTypeProperties {
    @JsonProperty(value="dataset", required=true)
    private DatasetReference dataset;
    @JsonProperty(value="fieldList")
    private List<Object> fieldList;
    @JsonProperty(value="storeSettings")
    private StoreReadSettings storeSettings;
    @JsonProperty(value="formatSettings")
    private FormatReadSettings formatSettings;
    private static final ClientLogger LOGGER = new ClientLogger(GetMetadataActivityTypeProperties.class);

    public DatasetReference dataset() {
        return this.dataset;
    }

    public GetMetadataActivityTypeProperties withDataset(DatasetReference dataset) {
        this.dataset = dataset;
        return this;
    }

    public List<Object> fieldList() {
        return this.fieldList;
    }

    public GetMetadataActivityTypeProperties withFieldList(List<Object> fieldList) {
        this.fieldList = fieldList;
        return this;
    }

    public StoreReadSettings storeSettings() {
        return this.storeSettings;
    }

    public GetMetadataActivityTypeProperties withStoreSettings(StoreReadSettings storeSettings) {
        this.storeSettings = storeSettings;
        return this;
    }

    public FormatReadSettings formatSettings() {
        return this.formatSettings;
    }

    public GetMetadataActivityTypeProperties withFormatSettings(FormatReadSettings formatSettings) {
        this.formatSettings = formatSettings;
        return this;
    }

    public void validate() {
        if (this.dataset() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property dataset in model GetMetadataActivityTypeProperties"));
        }
        this.dataset().validate();
        if (this.storeSettings() != null) {
            this.storeSettings().validate();
        }
        if (this.formatSettings() != null) {
            this.formatSettings().validate();
        }
    }
}

