/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.BigDataPoolParametrizationReference;
import com.azure.resourcemanager.datafactory.models.NotebookParameter;
import com.azure.resourcemanager.datafactory.models.SynapseNotebookReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class SynapseNotebookActivityTypeProperties {
    @JsonProperty(value="notebook", required=true)
    private SynapseNotebookReference notebook;
    @JsonProperty(value="sparkPool")
    private BigDataPoolParametrizationReference sparkPool;
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, NotebookParameter> parameters;
    @JsonProperty(value="executorSize")
    private Object executorSize;
    @JsonProperty(value="conf")
    private Object conf;
    @JsonProperty(value="driverSize")
    private Object driverSize;
    @JsonProperty(value="numExecutors")
    private Integer numExecutors;
    private static final ClientLogger LOGGER = new ClientLogger(SynapseNotebookActivityTypeProperties.class);

    public SynapseNotebookReference notebook() {
        return this.notebook;
    }

    public SynapseNotebookActivityTypeProperties withNotebook(SynapseNotebookReference notebook) {
        this.notebook = notebook;
        return this;
    }

    public BigDataPoolParametrizationReference sparkPool() {
        return this.sparkPool;
    }

    public SynapseNotebookActivityTypeProperties withSparkPool(BigDataPoolParametrizationReference sparkPool) {
        this.sparkPool = sparkPool;
        return this;
    }

    public Map<String, NotebookParameter> parameters() {
        return this.parameters;
    }

    public SynapseNotebookActivityTypeProperties withParameters(Map<String, NotebookParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Object executorSize() {
        return this.executorSize;
    }

    public SynapseNotebookActivityTypeProperties withExecutorSize(Object executorSize) {
        this.executorSize = executorSize;
        return this;
    }

    public Object conf() {
        return this.conf;
    }

    public SynapseNotebookActivityTypeProperties withConf(Object conf) {
        this.conf = conf;
        return this;
    }

    public Object driverSize() {
        return this.driverSize;
    }

    public SynapseNotebookActivityTypeProperties withDriverSize(Object driverSize) {
        this.driverSize = driverSize;
        return this;
    }

    public Integer numExecutors() {
        return this.numExecutors;
    }

    public SynapseNotebookActivityTypeProperties withNumExecutors(Integer numExecutors) {
        this.numExecutors = numExecutors;
        return this;
    }

    public void validate() {
        if (this.notebook() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property notebook in model SynapseNotebookActivityTypeProperties"));
        }
        this.notebook().validate();
        if (this.sparkPool() != null) {
            this.sparkPool().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

