/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.datafactory.fluent.ExposureControlsClient;
import com.azure.resourcemanager.datafactory.fluent.models.ExposureControlBatchResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.ExposureControlResponseInner;
import com.azure.resourcemanager.datafactory.implementation.DataFactoryManagementClientImpl;
import com.azure.resourcemanager.datafactory.models.ExposureControlBatchRequest;
import com.azure.resourcemanager.datafactory.models.ExposureControlRequest;
import reactor.core.publisher.Mono;

public final class ExposureControlsClientImpl
implements ExposureControlsClient {
    private final ExposureControlsService service;
    private final DataFactoryManagementClientImpl client;

    ExposureControlsClientImpl(DataFactoryManagementClientImpl client) {
        this.service = (ExposureControlsService)RestProxy.create(ExposureControlsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ExposureControlResponseInner>> getFeatureValueWithResponseAsync(String locationId, ExposureControlRequest exposureControlRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (locationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationId is required and cannot be null."));
        }
        if (exposureControlRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exposureControlRequest is required and cannot be null."));
        }
        exposureControlRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFeatureValue(this.client.getEndpoint(), this.client.getSubscriptionId(), locationId, this.client.getApiVersion(), exposureControlRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ExposureControlResponseInner>> getFeatureValueWithResponseAsync(String locationId, ExposureControlRequest exposureControlRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (locationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationId is required and cannot be null."));
        }
        if (exposureControlRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exposureControlRequest is required and cannot be null."));
        }
        exposureControlRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getFeatureValue(this.client.getEndpoint(), this.client.getSubscriptionId(), locationId, this.client.getApiVersion(), exposureControlRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExposureControlResponseInner> getFeatureValueAsync(String locationId, ExposureControlRequest exposureControlRequest) {
        return this.getFeatureValueWithResponseAsync(locationId, exposureControlRequest).flatMap(res -> Mono.justOrEmpty((Object)((ExposureControlResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExposureControlResponseInner> getFeatureValueWithResponse(String locationId, ExposureControlRequest exposureControlRequest, Context context) {
        return (Response)this.getFeatureValueWithResponseAsync(locationId, exposureControlRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExposureControlResponseInner getFeatureValue(String locationId, ExposureControlRequest exposureControlRequest) {
        return (ExposureControlResponseInner)this.getFeatureValueWithResponse(locationId, exposureControlRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ExposureControlResponseInner>> getFeatureValueByFactoryWithResponseAsync(String resourceGroupName, String factoryName, ExposureControlRequest exposureControlRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (exposureControlRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exposureControlRequest is required and cannot be null."));
        }
        exposureControlRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFeatureValueByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), exposureControlRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ExposureControlResponseInner>> getFeatureValueByFactoryWithResponseAsync(String resourceGroupName, String factoryName, ExposureControlRequest exposureControlRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (exposureControlRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exposureControlRequest is required and cannot be null."));
        }
        exposureControlRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getFeatureValueByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), exposureControlRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExposureControlResponseInner> getFeatureValueByFactoryAsync(String resourceGroupName, String factoryName, ExposureControlRequest exposureControlRequest) {
        return this.getFeatureValueByFactoryWithResponseAsync(resourceGroupName, factoryName, exposureControlRequest).flatMap(res -> Mono.justOrEmpty((Object)((ExposureControlResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExposureControlResponseInner> getFeatureValueByFactoryWithResponse(String resourceGroupName, String factoryName, ExposureControlRequest exposureControlRequest, Context context) {
        return (Response)this.getFeatureValueByFactoryWithResponseAsync(resourceGroupName, factoryName, exposureControlRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExposureControlResponseInner getFeatureValueByFactory(String resourceGroupName, String factoryName, ExposureControlRequest exposureControlRequest) {
        return (ExposureControlResponseInner)this.getFeatureValueByFactoryWithResponse(resourceGroupName, factoryName, exposureControlRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ExposureControlBatchResponseInner>> queryFeatureValuesByFactoryWithResponseAsync(String resourceGroupName, String factoryName, ExposureControlBatchRequest exposureControlBatchRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (exposureControlBatchRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exposureControlBatchRequest is required and cannot be null."));
        }
        exposureControlBatchRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.queryFeatureValuesByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), exposureControlBatchRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ExposureControlBatchResponseInner>> queryFeatureValuesByFactoryWithResponseAsync(String resourceGroupName, String factoryName, ExposureControlBatchRequest exposureControlBatchRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (exposureControlBatchRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exposureControlBatchRequest is required and cannot be null."));
        }
        exposureControlBatchRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.queryFeatureValuesByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), exposureControlBatchRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExposureControlBatchResponseInner> queryFeatureValuesByFactoryAsync(String resourceGroupName, String factoryName, ExposureControlBatchRequest exposureControlBatchRequest) {
        return this.queryFeatureValuesByFactoryWithResponseAsync(resourceGroupName, factoryName, exposureControlBatchRequest).flatMap(res -> Mono.justOrEmpty((Object)((ExposureControlBatchResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExposureControlBatchResponseInner> queryFeatureValuesByFactoryWithResponse(String resourceGroupName, String factoryName, ExposureControlBatchRequest exposureControlBatchRequest, Context context) {
        return (Response)this.queryFeatureValuesByFactoryWithResponseAsync(resourceGroupName, factoryName, exposureControlBatchRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExposureControlBatchResponseInner queryFeatureValuesByFactory(String resourceGroupName, String factoryName, ExposureControlBatchRequest exposureControlBatchRequest) {
        return (ExposureControlBatchResponseInner)this.queryFeatureValuesByFactoryWithResponse(resourceGroupName, factoryName, exposureControlBatchRequest, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataFactoryManagemen")
    public static interface ExposureControlsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.DataFactory/locations/{locationId}/getFeatureValue")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExposureControlResponseInner>> getFeatureValue(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="locationId") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ExposureControlRequest var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/getFeatureValue")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExposureControlResponseInner>> getFeatureValueByFactory(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") ExposureControlRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/queryFeaturesValue")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExposureControlBatchResponseInner>> queryFeatureValuesByFactory(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") ExposureControlBatchRequest var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

