/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.sagemaker.model.DeviceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDevicesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DeviceSummary> deviceSummaries;
    private String nextToken;

    public List<DeviceSummary> getDeviceSummaries() {
        return this.deviceSummaries;
    }

    public void setDeviceSummaries(Collection<DeviceSummary> deviceSummaries) {
        if (deviceSummaries == null) {
            this.deviceSummaries = null;
            return;
        }
        this.deviceSummaries = new ArrayList<DeviceSummary>(deviceSummaries);
    }

    public ListDevicesResult withDeviceSummaries(DeviceSummary ... deviceSummaries) {
        if (this.deviceSummaries == null) {
            this.setDeviceSummaries(new ArrayList<DeviceSummary>(deviceSummaries.length));
        }
        for (DeviceSummary ele : deviceSummaries) {
            this.deviceSummaries.add(ele);
        }
        return this;
    }

    public ListDevicesResult withDeviceSummaries(Collection<DeviceSummary> deviceSummaries) {
        this.setDeviceSummaries(deviceSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDevicesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeviceSummaries() != null) {
            sb.append("DeviceSummaries: ").append(this.getDeviceSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesResult)) {
            return false;
        }
        ListDevicesResult other = (ListDevicesResult)obj;
        if (other.getDeviceSummaries() == null ^ this.getDeviceSummaries() == null) {
            return false;
        }
        if (other.getDeviceSummaries() != null && !other.getDeviceSummaries().equals(this.getDeviceSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeviceSummaries() == null ? 0 : this.getDeviceSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListDevicesResult clone() {
        try {
            return (ListDevicesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

