/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.security;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.configuration.ApiConfig;
import org.apache.dolphinscheduler.api.security.AuthenticationType;
import org.apache.dolphinscheduler.api.security.Authenticator;
import org.apache.dolphinscheduler.api.security.impl.AbstractAuthenticator;
import org.apache.dolphinscheduler.api.security.impl.ldap.LdapAuthenticator;
import org.apache.dolphinscheduler.api.security.impl.oidc.OidcAuthenticator;
import org.apache.dolphinscheduler.api.security.impl.oidc.OidcConfigProperties;
import org.apache.dolphinscheduler.api.security.impl.pwd.PasswordAuthenticator;
import org.apache.dolphinscheduler.api.security.impl.sso.CasdoorAuthenticator;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class SecurityConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    @Value(value="${security.authentication.type:PASSWORD}")
    private String type;
    private final AutowireCapableBeanFactory beanFactory;
    private final OidcConfigProperties oidcConfig;
    private final UsersService usersService;
    private AuthenticationType authenticationType;
    private final ApiConfig apiConfig;

    @Autowired
    public SecurityConfig(AutowireCapableBeanFactory beanFactory, Optional<OidcConfigProperties> oidcConfig, Optional<UsersService> usersService, ApiConfig apiConfig) {
        this.beanFactory = beanFactory;
        this.oidcConfig = oidcConfig.orElse(null);
        this.usersService = usersService.orElse(null);
        this.apiConfig = apiConfig;
    }

    private void setAuthenticationType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            log.info("security.authentication.type configuration is empty, the default value 'PASSWORD'");
            this.authenticationType = AuthenticationType.PASSWORD;
            return;
        }
        this.authenticationType = AuthenticationType.valueOf(type);
    }

    @Bean(name={"authenticator"})
    @Primary
    public Authenticator authenticator() {
        AbstractAuthenticator authenticator;
        this.setAuthenticationType(this.type);
        switch (this.authenticationType) {
            case PASSWORD: {
                authenticator = new PasswordAuthenticator();
                break;
            }
            case LDAP: {
                authenticator = new LdapAuthenticator();
                break;
            }
            case CASDOOR_SSO: {
                authenticator = new CasdoorAuthenticator();
                break;
            }
            case OIDC: {
                if (this.oidcConfig == null || this.usersService == null) {
                    throw new IllegalStateException("OIDC authentication is configured, but required beans are not available.");
                }
                authenticator = new OidcAuthenticator(this.oidcConfig, this.usersService, this.apiConfig);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.authenticationType));
            }
        }
        this.beanFactory.autowireBean((Object)authenticator);
        return authenticator;
    }

    public String getType() {
        return this.type;
    }
}

