/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.api.dto.TaskStateCount;
import org.apache.dolphinscheduler.dao.entity.ExecuteStatusCount;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;

public class TaskCountDto {
    private int totalCount;
    private List<TaskStateCount> taskCountDtos;

    public TaskCountDto(List<ExecuteStatusCount> taskInstanceStateCounts) {
        this.countTaskDtos(taskInstanceStateCounts);
    }

    private void countTaskDtos(List<ExecuteStatusCount> taskInstanceStateCounts) {
        Map<TaskExecutionStatus, Integer> statusCountMap = taskInstanceStateCounts.stream().collect(Collectors.toMap(ExecuteStatusCount::getState, ExecuteStatusCount::getCount, Integer::sum));
        this.taskCountDtos = Arrays.stream(TaskExecutionStatus.values()).map(status -> new TaskStateCount((TaskExecutionStatus)status, statusCountMap.getOrDefault(status, 0))).collect(Collectors.toList());
        this.totalCount = this.taskCountDtos.stream().mapToInt(TaskStateCount::getCount).sum();
    }

    public void removeStateFromCountList(TaskExecutionStatus status) {
        for (TaskStateCount count : this.taskCountDtos) {
            if (!count.getTaskStateType().equals((Object)status)) continue;
            this.taskCountDtos.remove(count);
            break;
        }
    }

    @Generated
    public int getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public List<TaskStateCount> getTaskCountDtos() {
        return this.taskCountDtos;
    }

    @Generated
    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    @Generated
    public void setTaskCountDtos(List<TaskStateCount> taskCountDtos) {
        this.taskCountDtos = taskCountDtos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskCountDto)) {
            return false;
        }
        TaskCountDto other = (TaskCountDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        List<TaskStateCount> this$taskCountDtos = this.getTaskCountDtos();
        List<TaskStateCount> other$taskCountDtos = other.getTaskCountDtos();
        return !(this$taskCountDtos == null ? other$taskCountDtos != null : !((Object)this$taskCountDtos).equals(other$taskCountDtos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskCountDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalCount();
        List<TaskStateCount> $taskCountDtos = this.getTaskCountDtos();
        result = result * 59 + ($taskCountDtos == null ? 43 : ((Object)$taskCountDtos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskCountDto(totalCount=" + this.getTotalCount() + ", taskCountDtos=" + this.getTaskCountDtos() + ")";
    }

    @Generated
    public TaskCountDto() {
    }

    @Generated
    public TaskCountDto(int totalCount, List<TaskStateCount> taskCountDtos) {
        this.totalCount = totalCount;
        this.taskCountDtos = taskCountDtos;
    }
}

