/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.taskRelation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.stream.Stream;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TaskRelationDeleteRequest {
    private long upstreamCode;
    private long downstreamCode;
    @Schema(example="12345678,87654321", required=true, description="relation pair want to delete relation, separated by comma")
    private String codePair;

    public TaskRelationDeleteRequest(String relationPair) {
        long[] relations = Stream.of(relationPair.split(",")).map(String::trim).mapToLong(Long::parseLong).toArray();
        this.upstreamCode = relations[0];
        this.downstreamCode = relations[1];
    }

    @Generated
    public long getUpstreamCode() {
        return this.upstreamCode;
    }

    @Generated
    public long getDownstreamCode() {
        return this.downstreamCode;
    }

    @Generated
    public String getCodePair() {
        return this.codePair;
    }

    @Generated
    public void setUpstreamCode(long upstreamCode) {
        this.upstreamCode = upstreamCode;
    }

    @Generated
    public void setDownstreamCode(long downstreamCode) {
        this.downstreamCode = downstreamCode;
    }

    @Generated
    public void setCodePair(String codePair) {
        this.codePair = codePair;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskRelationDeleteRequest)) {
            return false;
        }
        TaskRelationDeleteRequest other = (TaskRelationDeleteRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUpstreamCode() != other.getUpstreamCode()) {
            return false;
        }
        if (this.getDownstreamCode() != other.getDownstreamCode()) {
            return false;
        }
        String this$codePair = this.getCodePair();
        String other$codePair = other.getCodePair();
        return !(this$codePair == null ? other$codePair != null : !this$codePair.equals(other$codePair));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskRelationDeleteRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $upstreamCode = this.getUpstreamCode();
        result = result * 59 + (int)($upstreamCode >>> 32 ^ $upstreamCode);
        long $downstreamCode = this.getDownstreamCode();
        result = result * 59 + (int)($downstreamCode >>> 32 ^ $downstreamCode);
        String $codePair = this.getCodePair();
        result = result * 59 + ($codePair == null ? 43 : $codePair.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskRelationDeleteRequest(upstreamCode=" + this.getUpstreamCode() + ", downstreamCode=" + this.getDownstreamCode() + ", codePair=" + this.getCodePair() + ")";
    }
}

