/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceCertificateInner;
import com.azure.resourcemanager.appservice.models.CertificateDetails;
import com.azure.resourcemanager.appservice.models.CertificateOrderContact;
import com.azure.resourcemanager.appservice.models.CertificateOrderStatus;
import com.azure.resourcemanager.appservice.models.CertificateProductType;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.ResourceNotRenewableReason;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class AppServiceCertificateOrderProperties {
    @JsonProperty(value="certificates")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, AppServiceCertificateInner> certificates;
    @JsonProperty(value="distinguishedName")
    private String distinguishedName;
    @JsonProperty(value="domainVerificationToken", access=JsonProperty.Access.WRITE_ONLY)
    private String domainVerificationToken;
    @JsonProperty(value="validityInYears")
    private Integer validityInYears;
    @JsonProperty(value="keySize")
    private Integer keySize;
    @JsonProperty(value="productType", required=true)
    private CertificateProductType productType;
    @JsonProperty(value="autoRenew")
    private Boolean autoRenew;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private CertificateOrderStatus status;
    @JsonProperty(value="signedCertificate", access=JsonProperty.Access.WRITE_ONLY)
    private CertificateDetails signedCertificate;
    @JsonProperty(value="csr")
    private String csr;
    @JsonProperty(value="intermediate", access=JsonProperty.Access.WRITE_ONLY)
    private CertificateDetails intermediate;
    @JsonProperty(value="root", access=JsonProperty.Access.WRITE_ONLY)
    private CertificateDetails root;
    @JsonProperty(value="serialNumber", access=JsonProperty.Access.WRITE_ONLY)
    private String serialNumber;
    @JsonProperty(value="lastCertificateIssuanceTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastCertificateIssuanceTime;
    @JsonProperty(value="expirationTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime expirationTime;
    @JsonProperty(value="isPrivateKeyExternal", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isPrivateKeyExternal;
    @JsonProperty(value="appServiceCertificateNotRenewableReasons", access=JsonProperty.Access.WRITE_ONLY)
    private List<ResourceNotRenewableReason> appServiceCertificateNotRenewableReasons;
    @JsonProperty(value="nextAutoRenewalTimeStamp", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime nextAutoRenewalTimestamp;
    @JsonProperty(value="contact", access=JsonProperty.Access.WRITE_ONLY)
    private CertificateOrderContact contact;
    private static final ClientLogger LOGGER = new ClientLogger(AppServiceCertificateOrderProperties.class);

    public Map<String, AppServiceCertificateInner> certificates() {
        return this.certificates;
    }

    public AppServiceCertificateOrderProperties withCertificates(Map<String, AppServiceCertificateInner> certificates) {
        this.certificates = certificates;
        return this;
    }

    public String distinguishedName() {
        return this.distinguishedName;
    }

    public AppServiceCertificateOrderProperties withDistinguishedName(String distinguishedName) {
        this.distinguishedName = distinguishedName;
        return this;
    }

    public String domainVerificationToken() {
        return this.domainVerificationToken;
    }

    public Integer validityInYears() {
        return this.validityInYears;
    }

    public AppServiceCertificateOrderProperties withValidityInYears(Integer validityInYears) {
        this.validityInYears = validityInYears;
        return this;
    }

    public Integer keySize() {
        return this.keySize;
    }

    public AppServiceCertificateOrderProperties withKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    public CertificateProductType productType() {
        return this.productType;
    }

    public AppServiceCertificateOrderProperties withProductType(CertificateProductType productType) {
        this.productType = productType;
        return this;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public AppServiceCertificateOrderProperties withAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public CertificateOrderStatus status() {
        return this.status;
    }

    public CertificateDetails signedCertificate() {
        return this.signedCertificate;
    }

    public String csr() {
        return this.csr;
    }

    public AppServiceCertificateOrderProperties withCsr(String csr) {
        this.csr = csr;
        return this;
    }

    public CertificateDetails intermediate() {
        return this.intermediate;
    }

    public CertificateDetails root() {
        return this.root;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public OffsetDateTime lastCertificateIssuanceTime() {
        return this.lastCertificateIssuanceTime;
    }

    public OffsetDateTime expirationTime() {
        return this.expirationTime;
    }

    public Boolean isPrivateKeyExternal() {
        return this.isPrivateKeyExternal;
    }

    public List<ResourceNotRenewableReason> appServiceCertificateNotRenewableReasons() {
        return this.appServiceCertificateNotRenewableReasons;
    }

    public OffsetDateTime nextAutoRenewalTimestamp() {
        return this.nextAutoRenewalTimestamp;
    }

    public CertificateOrderContact contact() {
        return this.contact;
    }

    public void validate() {
        if (this.certificates() != null) {
            this.certificates().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.productType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property productType in model AppServiceCertificateOrderProperties"));
        }
        if (this.signedCertificate() != null) {
            this.signedCertificate().validate();
        }
        if (this.intermediate() != null) {
            this.intermediate().validate();
        }
        if (this.root() != null) {
            this.root().validate();
        }
        if (this.contact() != null) {
            this.contact().validate();
        }
    }
}

