/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.tz.FixedDateTimeZone;

public class DateUtils {
    private static final DateTimeZone GMT = new FixedDateTimeZone("GMT", "GMT", 0, 0);
    private static final long MILLI_SECONDS_OF_365_DAYS = 31536000000L;
    protected static final DateTimeFormatter rfc822DateFormat = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(GMT);
    protected static final DateTimeFormatter iso8601DateFormat = ISODateTimeFormat.dateTime().withZone(GMT);
    protected static final DateTimeFormatter alternateIso8601DateFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(GMT);

    public static String formatRFC822Date(Date date) {
        return rfc822DateFormat.print(date.getTime());
    }

    public static Date parseRFC822Date(String dateString) {
        return new Date(rfc822DateFormat.parseMillis(dateString));
    }

    public static String formatISO8601Date(Date date) {
        return iso8601DateFormat.print(date.getTime());
    }

    public static Date parseISO8601Date(String dateString) {
        if (dateString.endsWith("+0000")) {
            dateString = dateString.substring(0, dateString.length() - 5).concat("Z");
        }
        String temp = DateUtils.tempDateStringForJodaTime(dateString);
        try {
            if (temp.equals(dateString)) {
                return new Date(iso8601DateFormat.parseMillis(dateString));
            }
            long milliLess365Days = iso8601DateFormat.parseMillis(temp);
            long milli = milliLess365Days + 31536000000L;
            if (milli < 0L) {
                return new Date(iso8601DateFormat.parseMillis(dateString));
            }
            return new Date(milli);
        }
        catch (IllegalArgumentException e) {
            try {
                return new Date(alternateIso8601DateFormat.parseMillis(dateString));
            }
            catch (Exception oops) {
                throw e;
            }
        }
    }

    private static String tempDateStringForJodaTime(String dateString) {
        String fromPrefix = "292278994-";
        String toPrefix = "292278993-";
        return dateString.startsWith("292278994-") ? "292278993-" + dateString.substring("292278994-".length()) : dateString;
    }
}

