/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphApplicationInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphGroupInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphServicePrincipalInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphUserInner;
import com.azure.resourcemanager.authorization.implementation.ActiveDirectoryApplicationImpl;
import com.azure.resourcemanager.authorization.implementation.ActiveDirectoryUserImpl;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import com.azure.resourcemanager.authorization.implementation.ServicePrincipalImpl;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryGroup;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryObject;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryUser;
import com.azure.resourcemanager.authorization.models.ServicePrincipal;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ActiveDirectoryGroupImpl
extends CreatableUpdatableImpl<ActiveDirectoryGroup, MicrosoftGraphGroupInner, ActiveDirectoryGroupImpl>
implements ActiveDirectoryGroup,
ActiveDirectoryGroup.Definition,
ActiveDirectoryGroup.Update {
    private final AuthorizationManager manager;
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private Set<Map<String, Object>> membersToAdd;
    private Set<String> membersToRemove;

    ActiveDirectoryGroupImpl(MicrosoftGraphGroupInner innerModel, AuthorizationManager manager) {
        super(innerModel.displayName(), (Object)innerModel);
        this.manager = manager;
        this.membersToAdd = new HashSet<Map<String, Object>>();
        this.membersToRemove = new HashSet<String>();
    }

    @Override
    public boolean securityEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((MicrosoftGraphGroupInner)this.innerModel()).securityEnabled());
    }

    @Override
    public String mail() {
        return ((MicrosoftGraphGroupInner)this.innerModel()).mail();
    }

    @Override
    public List<ActiveDirectoryObject> listMembers() {
        return (List)this.listMembersAsync().collectList().block();
    }

    @Override
    public PagedFlux<ActiveDirectoryObject> listMembersAsync() {
        return PagedConverter.flatMapPage(this.manager().serviceClient().getGroups().listMembersAsync(this.id()), directoryObjectInner -> Mono.justOrEmpty((Object)this.parseDirectoryObject((MicrosoftGraphDirectoryObjectInner)directoryObjectInner)));
    }

    private ActiveDirectoryObject parseDirectoryObject(MicrosoftGraphDirectoryObjectInner inner) {
        Object odataTypeObject;
        if (inner.additionalProperties() != null && (odataTypeObject = inner.additionalProperties().get("@odata.type")) instanceof String) {
            SerializerAdapter serializerAdapter = ((MicrosoftGraphClientImpl)this.manager().serviceClient()).getSerializerAdapter();
            String odataType = ((String)odataTypeObject).toLowerCase(Locale.ROOT);
            try {
                String jsonString = serializerAdapter.serialize((Object)inner, SerializerEncoding.JSON);
                if (odataType.endsWith("#microsoft.graph.user")) {
                    MicrosoftGraphUserInner userInner = (MicrosoftGraphUserInner)serializerAdapter.deserialize(jsonString, MicrosoftGraphUserInner.class, SerializerEncoding.JSON);
                    return new ActiveDirectoryUserImpl(userInner, this.manager());
                }
                if (odataType.endsWith("#microsoft.graph.group")) {
                    MicrosoftGraphGroupInner groupInner = (MicrosoftGraphGroupInner)serializerAdapter.deserialize(jsonString, MicrosoftGraphGroupInner.class, SerializerEncoding.JSON);
                    return new ActiveDirectoryGroupImpl(groupInner, this.manager());
                }
                if (odataType.endsWith("#microsoft.graph.serviceprincipal")) {
                    MicrosoftGraphServicePrincipalInner servicePrincipalInner = (MicrosoftGraphServicePrincipalInner)serializerAdapter.deserialize(jsonString, MicrosoftGraphServicePrincipalInner.class, SerializerEncoding.JSON);
                    return new ServicePrincipalImpl(servicePrincipalInner, this.manager());
                }
                if (odataType.endsWith("#microsoft.graph.application")) {
                    MicrosoftGraphApplicationInner applicationInner = (MicrosoftGraphApplicationInner)serializerAdapter.deserialize(jsonString, MicrosoftGraphApplicationInner.class, SerializerEncoding.JSON);
                    return new ActiveDirectoryApplicationImpl(applicationInner, this.manager());
                }
                this.logger.warning("Can't recognize member type '{}' of ActiveDirectoryGroup", new Object[]{odataType});
                return null;
            }
            catch (IOException e) {
                this.logger.logThrowableAsWarning((Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected Mono<MicrosoftGraphGroupInner> getInnerAsync() {
        return this.manager().serviceClient().getGroupsGroups().getGroupAsync(this.id());
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    public Mono<ActiveDirectoryGroup> createResourceAsync() {
        Mono group = Mono.just((Object)this);
        if (this.isInCreateMode()) {
            if (((MicrosoftGraphGroupInner)this.innerModel()).mailEnabled() == null) {
                ((MicrosoftGraphGroupInner)this.innerModel()).withMailEnabled(false);
            }
            if (((MicrosoftGraphGroupInner)this.innerModel()).securityEnabled() == null) {
                ((MicrosoftGraphGroupInner)this.innerModel()).withSecurityEnabled(true);
            }
            group = this.manager().serviceClient().getGroupsGroups().createGroupAsync((MicrosoftGraphGroupInner)this.innerModel()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
        }
        if (!this.membersToRemove.isEmpty()) {
            group = group.flatMap(o -> Flux.fromIterable(this.membersToRemove).flatMap(s -> this.manager().serviceClient().getGroups().deleteRefMemberAsync(this.id(), (String)s)).singleOrEmpty().thenReturn((Object)this).doFinally(signalType -> this.membersToRemove.clear()));
        }
        if (!this.membersToAdd.isEmpty()) {
            group = group.flatMap(o -> Flux.fromIterable(this.membersToAdd).flatMap(s -> this.manager().serviceClient().getGroups().createRefMembersAsync(this.id(), (Map<String, Object>)s)).singleOrEmpty().thenReturn((Object)this).doFinally(signalType -> this.membersToAdd.clear()));
        }
        return group;
    }

    @Override
    public ActiveDirectoryGroupImpl withEmailAlias(String mailNickname) {
        if (mailNickname.contains("@")) {
            String[] parts = mailNickname.split("@");
            mailNickname = parts[0];
        }
        ((MicrosoftGraphGroupInner)this.innerModel()).withMailNickname(mailNickname);
        return this;
    }

    @Override
    public ActiveDirectoryGroupImpl withMember(String objectId) {
        String membersKey = "@odata.id";
        this.membersToAdd.add(Collections.singletonMap(membersKey, String.format("%s/directoryObjects/%s", this.manager().serviceClient().getEndpoint(), objectId)));
        return this;
    }

    @Override
    public ActiveDirectoryGroupImpl withMember(ActiveDirectoryUser user) {
        return this.withMember(user.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withMember(ActiveDirectoryGroup group) {
        return this.withMember(group.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withMember(ServicePrincipal servicePrincipal) {
        return this.withMember(servicePrincipal.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withoutMember(String objectId) {
        this.membersToRemove.add(objectId);
        return this;
    }

    @Override
    public ActiveDirectoryGroupImpl withoutMember(ActiveDirectoryUser user) {
        return this.withoutMember(user.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withoutMember(ActiveDirectoryGroup group) {
        return this.withoutMember(group.id());
    }

    @Override
    public ActiveDirectoryGroupImpl withoutMember(ServicePrincipal servicePrincipal) {
        return this.withoutMember(servicePrincipal.id());
    }

    public String id() {
        return ((MicrosoftGraphGroupInner)this.innerModel()).id();
    }

    public AuthorizationManager manager() {
        return this.manager;
    }
}

