/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.hdfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.CommonUtils;
import org.apache.dolphinscheduler.plugin.storage.api.AbstractStorageOperator;
import org.apache.dolphinscheduler.plugin.storage.api.ResourceMetadata;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.storage.hdfs.HdfsStorageProperties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsStorageOperator
extends AbstractStorageOperator
implements Closeable,
StorageOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HdfsStorageOperator.class);
    private final HdfsStorageProperties hdfsProperties;
    private Configuration configuration;
    private FileSystem fs;

    public HdfsStorageOperator(HdfsStorageProperties hdfsStorageProperties) {
        super(hdfsStorageProperties.getResourceUploadPath());
        this.hdfsProperties = hdfsStorageProperties;
        this.init();
        this.initHdfsPath();
    }

    private void initHdfsPath() {
        Path path = new Path(this.resourceBaseAbsolutePath);
        if (!this.fs.exists(path)) {
            if (!this.fs.mkdirs(path)) {
                log.info("Create hdfs path: {} failed", (Object)path);
            } else {
                log.error("Create hdfs path: {} success", (Object)path);
            }
        }
    }

    private void init() {
        String defaultFS;
        this.configuration = new HdfsConfiguration();
        if (MapUtils.isNotEmpty(this.hdfsProperties.getConfigurationProperties())) {
            this.hdfsProperties.getConfigurationProperties().forEach((key, value) -> {
                this.configuration.set(key, value);
                log.info("Set HDFS prop: {}  -> {}", key, value);
            });
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaultFS = this.hdfsProperties.getDefaultFS()))) {
            this.configuration.set("fs.defaultFS", this.hdfsProperties.getDefaultFS());
        }
        if (CommonUtils.getKerberosStartupState()) {
            CommonUtils.loadKerberosConf((Configuration)this.configuration);
            Long kerberosExpireTimeInHour = PropertyUtils.getLong((String)"kerberos.expire.time", (Long)-1L);
            if (kerberosExpireTimeInHour > 0L) {
                ThreadUtils.newDaemonScheduledExecutorService((String)"ds-hdfs-kerberos-refresh-%s", (int)1).scheduleWithFixedDelay(() -> {
                    try {
                        UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
                        this.fs = FileSystem.get((Configuration)this.configuration);
                        log.info("checkTGTAndReloginFromKeytab finished");
                    }
                    catch (Exception e) {
                        log.error("checkTGTAndReloginFromKeytab Error", (Throwable)e);
                    }
                }, kerberosExpireTimeInHour, kerberosExpireTimeInHour, TimeUnit.HOURS);
            }
            this.fs = FileSystem.get((Configuration)this.configuration);
            log.info("Initialize HdfsStorageOperator with kerberos");
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.hdfsProperties.getUser())) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.hdfsProperties.getUser());
            ugi.doAs(() -> {
                this.fs = FileSystem.get((Configuration)this.configuration);
                return true;
            });
            UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
            log.info("Initialize HdfsStorageOperator with remote user: {}", (Object)this.hdfsProperties.getUser());
            return;
        }
        this.fs = FileSystem.get((Configuration)this.configuration);
        log.info("Initialize HdfsStorageOperator with default user");
    }

    public String getStorageBaseDirectory() {
        String defaultFS = this.hdfsProperties.getDefaultFS();
        return FileUtils.concatFilePath((String[])new String[]{defaultFS, this.resourceBaseAbsolutePath});
    }

    /*
     * Exception decompiling
     */
    public List<String> fetchFileContent(String hdfsFilePath, int skipLineNums, int limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createStorageDir(String directoryAbsolutePath) {
        Path path = new Path(directoryAbsolutePath);
        if (this.fs.exists(path)) {
            throw new FileAlreadyExistsException("Directory already exists: " + directoryAbsolutePath);
        }
        this.fs.mkdirs(new Path(directoryAbsolutePath));
    }

    public void download(String srcHdfsFilePath, String dstFile, boolean overwrite) {
        Path srcPath = new Path(srcHdfsFilePath);
        File dstPath = new File(dstFile);
        if (dstPath.exists()) {
            if (dstPath.isFile()) {
                if (overwrite) {
                    Files.delete(dstPath.toPath());
                }
            } else {
                log.error("destination file must be a file");
            }
        }
        if (!dstPath.getParentFile().exists() && !dstPath.getParentFile().mkdirs()) {
            throw new IOException("Failed to create parent directory for destination file");
        }
        FileUtil.copy((FileSystem)this.fs, (Path)srcPath, (File)dstPath, (boolean)false, (Configuration)this.fs.getConf());
    }

    public void copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) {
        FileUtil.copy((FileSystem)this.fs, (Path)new Path(srcPath), (FileSystem)this.fs, (Path)new Path(dstPath), (boolean)deleteSource, (boolean)overwrite, (Configuration)this.fs.getConf());
    }

    public void upload(String srcAbsoluteFilePath, String dstAbsoluteFilePath, boolean deleteSource, boolean overwrite) {
        Path srcPath = new Path(srcAbsoluteFilePath);
        Path dstPath = new Path(dstAbsoluteFilePath);
        this.fs.copyFromLocalFile(deleteSource, overwrite, srcPath, dstPath);
    }

    public void delete(String resourceAbsolutePath, boolean recursive) {
        this.exceptionIfPathEmpty(resourceAbsolutePath);
        this.fs.delete(new Path(resourceAbsolutePath), recursive);
    }

    public boolean exists(String resourceAbsolutePath) {
        this.exceptionIfPathEmpty(resourceAbsolutePath);
        return this.fs.exists(new Path(resourceAbsolutePath));
    }

    public List<StorageEntity> listStorageEntity(String resourceAbsolutePath) {
        this.exceptionIfPathEmpty(resourceAbsolutePath);
        Path path = new Path(resourceAbsolutePath);
        if (!this.fs.exists(path)) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.fs.listStatus(new Path(resourceAbsolutePath))).map(this::transformFileStatusToResourceMetadata).collect(Collectors.toList());
    }

    public List<StorageEntity> listFileStorageEntityRecursively(String resourceAbsolutePath) {
        this.exceptionIfPathEmpty(resourceAbsolutePath);
        ArrayList<StorageEntity> result = new ArrayList<StorageEntity>();
        LinkedList<String> foldersToFetch = new LinkedList<String>();
        foldersToFetch.addLast(resourceAbsolutePath);
        while (!foldersToFetch.isEmpty()) {
            FileStatus[] fileStatuses;
            String absolutePath = (String)foldersToFetch.pollFirst();
            Path path = new Path(absolutePath);
            if (!this.fs.exists(path)) continue;
            for (FileStatus fileStatus : fileStatuses = this.fs.listStatus(path)) {
                if (fileStatus.isDirectory()) {
                    foldersToFetch.addLast(fileStatus.getPath().toString());
                }
                result.add(this.transformFileStatusToResourceMetadata(fileStatus));
            }
        }
        return result;
    }

    public StorageEntity getStorageEntity(String resourceAbsolutePath) {
        this.exceptionIfPathEmpty(resourceAbsolutePath);
        FileStatus fileStatus = this.fs.getFileStatus(new Path(resourceAbsolutePath));
        return this.transformFileStatusToResourceMetadata(fileStatus);
    }

    @Override
    public void close() throws IOException {
        if (this.fs != null) {
            try {
                this.fs.close();
            }
            catch (IOException e) {
                log.error("Close HadoopUtils instance failed", (Throwable)e);
                throw new IOException("Close HadoopUtils instance failed", e);
            }
        }
    }

    private StorageEntity transformFileStatusToResourceMetadata(FileStatus fileStatus) {
        Path fileStatusPath = fileStatus.getPath();
        String fileAbsolutePath = fileStatusPath.toString();
        ResourceMetadata resourceMetaData = this.getResourceMetaData(fileAbsolutePath);
        return StorageEntity.builder().fileName(fileStatusPath.getName()).fullName(fileAbsolutePath).pfullName(resourceMetaData.getResourceParentAbsolutePath()).type(resourceMetaData.getResourceType()).isDirectory(fileStatus.isDirectory()).size(fileStatus.getLen()).relativePath(resourceMetaData.getResourceRelativePath()).createTime(new Date(fileStatus.getModificationTime())).updateTime(new Date(fileStatus.getModificationTime())).build();
    }
}

