/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.resourcemanager.appservice.fluent.models.MSDeployStatusInner;
import com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.azure.resourcemanager.appservice.models.MSDeploy;
import com.azure.resourcemanager.appservice.models.MSDeployCore;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebDeployment;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.ExecutableImpl;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import reactor.core.publisher.Mono;

public class WebDeploymentImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends ExecutableImpl<WebDeployment>
implements WebDeployment,
WebDeployment.Definition {
    private final WebAppBaseImpl<FluentT, FluentImplT> parent;
    private MSDeploy request;
    private MSDeployStatusInner result;

    WebDeploymentImpl(WebAppBaseImpl<FluentT, FluentImplT> parent) {
        this.parent = parent;
        this.request = new MSDeploy();
    }

    public WebAppBase parent() {
        return this.parent;
    }

    @Override
    public String deployer() {
        return this.result.deployer();
    }

    @Override
    public OffsetDateTime startTime() {
        return this.result.startTime();
    }

    @Override
    public OffsetDateTime endTime() {
        return this.result.endTime();
    }

    @Override
    public boolean complete() {
        return this.result.complete();
    }

    @Override
    public WebDeploymentImpl<FluentT, FluentImplT> withPackageUri(String packageUri) {
        this.request.withAddOnPackages(new ArrayList<MSDeployCore>());
        this.request.addOnPackages().add(new MSDeployCore().withPackageUri(packageUri));
        return this;
    }

    public Mono<WebDeployment> executeWorkAsync() {
        return this.parent.createMSDeploy(this.request).map(msDeployStatusInner -> {
            this.result = msDeployStatusInner;
            return this;
        });
    }

    @Override
    public WebDeploymentImpl<FluentT, FluentImplT> withExistingDeploymentsDeleted(boolean deleteExisting) {
        if (deleteExisting) {
            MSDeployCore first = this.request.addOnPackages().remove(0);
            this.request.withPackageUri(first.packageUri());
        }
        return this;
    }

    @Override
    public WebDeploymentImpl<FluentT, FluentImplT> withAddOnPackage(String packageUri) {
        this.request.addOnPackages().add(new MSDeployCore().withPackageUri(packageUri));
        return this;
    }

    @Override
    public WebDeploymentImpl<FluentT, FluentImplT> withSetParametersXmlFile(String fileUri) {
        this.request.withSetParametersXmlFileUri(fileUri);
        return this;
    }

    @Override
    public WebDeploymentImpl<FluentT, FluentImplT> withSetParameter(String name, String value) {
        if (this.request.setParameters() == null) {
            this.request.withSetParameters(new HashMap<String, String>());
        }
        this.request.setParameters().put(name, value);
        return this;
    }
}

