/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.enums.dp;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OperatorType {
    EQ(0, "equal"),
    LT(1, "little than"),
    LE(2, "little and equal"),
    GT(3, "great than"),
    GE(4, "great and equal"),
    NE(5, "not equal");

    private final int code;
    private final String description;
    private static final Map<Integer, OperatorType> VALUES_MAP;

    private OperatorType(int code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonValue
    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static OperatorType of(Integer status) {
        if (VALUES_MAP.containsKey(status)) {
            return VALUES_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid code : " + status);
    }

    static {
        VALUES_MAP = new HashMap<Integer, OperatorType>();
        for (OperatorType type : OperatorType.values()) {
            VALUES_MAP.put(type.code, type);
        }
    }
}

