/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.sql.fluent.models.ManagedInstanceProperties;
import com.azure.resourcemanager.sql.models.ManagedInstanceLicenseType;
import com.azure.resourcemanager.sql.models.ManagedInstanceProxyOverride;
import com.azure.resourcemanager.sql.models.ManagedServerCreateMode;
import com.azure.resourcemanager.sql.models.ResourceIdentity;
import com.azure.resourcemanager.sql.models.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ManagedInstanceInner
extends Resource {
    @JsonProperty(value="identity")
    private ResourceIdentity identity;
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="properties")
    private ManagedInstanceProperties innerProperties;

    public ResourceIdentity identity() {
        return this.identity;
    }

    public ManagedInstanceInner withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public ManagedInstanceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private ManagedInstanceProperties innerProperties() {
        return this.innerProperties;
    }

    public ManagedInstanceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ManagedInstanceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ManagedServerCreateMode managedInstanceCreateMode() {
        return this.innerProperties() == null ? null : this.innerProperties().managedInstanceCreateMode();
    }

    public ManagedInstanceInner withManagedInstanceCreateMode(ManagedServerCreateMode managedInstanceCreateMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withManagedInstanceCreateMode(managedInstanceCreateMode);
        return this;
    }

    public String fullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainName();
    }

    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    public ManagedInstanceInner withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    public ManagedInstanceInner withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    public ManagedInstanceInner withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public ManagedInstanceLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public ManagedInstanceInner withLicenseType(ManagedInstanceLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public Integer vCores() {
        return this.innerProperties() == null ? null : this.innerProperties().vCores();
    }

    public ManagedInstanceInner withVCores(Integer vCores) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withVCores(vCores);
        return this;
    }

    public Integer storageSizeInGB() {
        return this.innerProperties() == null ? null : this.innerProperties().storageSizeInGB();
    }

    public ManagedInstanceInner withStorageSizeInGB(Integer storageSizeInGB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withStorageSizeInGB(storageSizeInGB);
        return this;
    }

    public String collation() {
        return this.innerProperties() == null ? null : this.innerProperties().collation();
    }

    public ManagedInstanceInner withCollation(String collation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withCollation(collation);
        return this;
    }

    public String dnsZone() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsZone();
    }

    public String dnsZonePartner() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsZonePartner();
    }

    public ManagedInstanceInner withDnsZonePartner(String dnsZonePartner) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withDnsZonePartner(dnsZonePartner);
        return this;
    }

    public Boolean publicDataEndpointEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().publicDataEndpointEnabled();
    }

    public ManagedInstanceInner withPublicDataEndpointEnabled(Boolean publicDataEndpointEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withPublicDataEndpointEnabled(publicDataEndpointEnabled);
        return this;
    }

    public String sourceManagedInstanceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceManagedInstanceId();
    }

    public ManagedInstanceInner withSourceManagedInstanceId(String sourceManagedInstanceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withSourceManagedInstanceId(sourceManagedInstanceId);
        return this;
    }

    public OffsetDateTime restorePointInTime() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointInTime();
    }

    public ManagedInstanceInner withRestorePointInTime(OffsetDateTime restorePointInTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withRestorePointInTime(restorePointInTime);
        return this;
    }

    public ManagedInstanceProxyOverride proxyOverride() {
        return this.innerProperties() == null ? null : this.innerProperties().proxyOverride();
    }

    public ManagedInstanceInner withProxyOverride(ManagedInstanceProxyOverride proxyOverride) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withProxyOverride(proxyOverride);
        return this;
    }

    public String timezoneId() {
        return this.innerProperties() == null ? null : this.innerProperties().timezoneId();
    }

    public ManagedInstanceInner withTimezoneId(String timezoneId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withTimezoneId(timezoneId);
        return this;
    }

    public String instancePoolId() {
        return this.innerProperties() == null ? null : this.innerProperties().instancePoolId();
    }

    public ManagedInstanceInner withInstancePoolId(String instancePoolId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withInstancePoolId(instancePoolId);
        return this;
    }

    public String minimalTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimalTlsVersion();
    }

    public ManagedInstanceInner withMinimalTlsVersion(String minimalTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

