/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc.repository;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.plugin.registry.jdbc.mapper.JdbcRegistryDataChangeEventMapper;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DO.JdbcRegistryDataChangeEvent;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.JdbcRegistryDataChangeEventDTO;
import org.springframework.stereotype.Repository;

@Repository
public class JdbcRegistryDataChangeEventRepository {
    private final JdbcRegistryDataChangeEventMapper jdbcRegistryDataChangeEventMapper;

    public JdbcRegistryDataChangeEventRepository(JdbcRegistryDataChangeEventMapper jdbcRegistryDataChangeEventMapper) {
        this.jdbcRegistryDataChangeEventMapper = jdbcRegistryDataChangeEventMapper;
    }

    public long getMaxJdbcRegistryDataChangeEventId() {
        Long maxId = this.jdbcRegistryDataChangeEventMapper.getMaxId();
        if (maxId == null) {
            return -1L;
        }
        return maxId;
    }

    public List<JdbcRegistryDataChangeEventDTO> selectJdbcRegistryDataChangeEventWhereIdAfter(long id) {
        return this.jdbcRegistryDataChangeEventMapper.selectJdbcRegistryDataChangeEventWhereIdAfter(id).stream().map(JdbcRegistryDataChangeEventDTO::fromJdbcRegistryDataChangeEvent).collect(Collectors.toList());
    }

    public void insert(JdbcRegistryDataChangeEventDTO registryDataChangeEvent) {
        JdbcRegistryDataChangeEvent jdbcRegistryDataChangeEvent = JdbcRegistryDataChangeEventDTO.toJdbcRegistryDataChangeEvent(registryDataChangeEvent);
        this.jdbcRegistryDataChangeEventMapper.insert(jdbcRegistryDataChangeEvent);
        registryDataChangeEvent.setId(jdbcRegistryDataChangeEvent.getId());
    }

    public void deleteJdbcRegistryDataChangeEventBeforeCreateTime(Date createTime) {
        this.jdbcRegistryDataChangeEventMapper.deleteJdbcRegistryDataChangeEventBeforeCreateTime(createTime);
    }
}

