/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.DependencyReference;
import com.azure.resourcemanager.datafactory.models.RetryPolicy;
import com.azure.resourcemanager.datafactory.models.TumblingWindowFrequency;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class TumblingWindowTriggerTypeProperties {
    @JsonProperty(value="frequency", required=true)
    private TumblingWindowFrequency frequency;
    @JsonProperty(value="interval", required=true)
    private int interval;
    @JsonProperty(value="startTime", required=true)
    private OffsetDateTime startTime;
    @JsonProperty(value="endTime")
    private OffsetDateTime endTime;
    @JsonProperty(value="delay")
    private Object delay;
    @JsonProperty(value="maxConcurrency", required=true)
    private int maxConcurrency;
    @JsonProperty(value="retryPolicy")
    private RetryPolicy retryPolicy;
    @JsonProperty(value="dependsOn")
    private List<DependencyReference> dependsOn;
    private static final ClientLogger LOGGER = new ClientLogger(TumblingWindowTriggerTypeProperties.class);

    public TumblingWindowFrequency frequency() {
        return this.frequency;
    }

    public TumblingWindowTriggerTypeProperties withFrequency(TumblingWindowFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    public int interval() {
        return this.interval;
    }

    public TumblingWindowTriggerTypeProperties withInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public TumblingWindowTriggerTypeProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public TumblingWindowTriggerTypeProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public Object delay() {
        return this.delay;
    }

    public TumblingWindowTriggerTypeProperties withDelay(Object delay) {
        this.delay = delay;
        return this;
    }

    public int maxConcurrency() {
        return this.maxConcurrency;
    }

    public TumblingWindowTriggerTypeProperties withMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    public RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public TumblingWindowTriggerTypeProperties withRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public List<DependencyReference> dependsOn() {
        return this.dependsOn;
    }

    public TumblingWindowTriggerTypeProperties withDependsOn(List<DependencyReference> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public void validate() {
        if (this.frequency() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property frequency in model TumblingWindowTriggerTypeProperties"));
        }
        if (this.startTime() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property startTime in model TumblingWindowTriggerTypeProperties"));
        }
        if (this.retryPolicy() != null) {
            this.retryPolicy().validate();
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
    }
}

