/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.DatasetsClient;
import com.azure.resourcemanager.datafactory.fluent.models.DatasetResourceInner;
import com.azure.resourcemanager.datafactory.implementation.DatasetResourceImpl;
import com.azure.resourcemanager.datafactory.implementation.Utils;
import com.azure.resourcemanager.datafactory.models.DatasetResource;
import com.azure.resourcemanager.datafactory.models.Datasets;

public final class DatasetsImpl
implements Datasets {
    private static final ClientLogger LOGGER = new ClientLogger(DatasetsImpl.class);
    private final DatasetsClient innerClient;
    private final DataFactoryManager serviceManager;

    public DatasetsImpl(DatasetsClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DatasetResource> listByFactory(String resourceGroupName, String factoryName) {
        PagedIterable<DatasetResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName);
        return Utils.mapPage(inner, inner1 -> new DatasetResourceImpl((DatasetResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DatasetResource> listByFactory(String resourceGroupName, String factoryName, Context context) {
        PagedIterable<DatasetResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName, context);
        return Utils.mapPage(inner, inner1 -> new DatasetResourceImpl((DatasetResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<DatasetResource> getWithResponse(String resourceGroupName, String factoryName, String datasetName, String ifNoneMatch, Context context) {
        Response<DatasetResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, factoryName, datasetName, ifNoneMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DatasetResourceImpl((DatasetResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DatasetResource get(String resourceGroupName, String factoryName, String datasetName) {
        DatasetResourceInner inner = this.serviceClient().get(resourceGroupName, factoryName, datasetName);
        if (inner != null) {
            return new DatasetResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String datasetName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, datasetName, context);
    }

    @Override
    public void delete(String resourceGroupName, String factoryName, String datasetName) {
        this.serviceClient().delete(resourceGroupName, factoryName, datasetName);
    }

    @Override
    public DatasetResource getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String datasetName = Utils.getValueFromIdByName(id, "datasets");
        if (datasetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'datasets'.", id)));
        }
        String localIfNoneMatch = null;
        return (DatasetResource)this.getWithResponse(resourceGroupName, factoryName, datasetName, localIfNoneMatch, Context.NONE).getValue();
    }

    @Override
    public Response<DatasetResource> getByIdWithResponse(String id, String ifNoneMatch, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String datasetName = Utils.getValueFromIdByName(id, "datasets");
        if (datasetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'datasets'.", id)));
        }
        return this.getWithResponse(resourceGroupName, factoryName, datasetName, ifNoneMatch, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String datasetName = Utils.getValueFromIdByName(id, "datasets");
        if (datasetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'datasets'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, factoryName, datasetName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String datasetName = Utils.getValueFromIdByName(id, "datasets");
        if (datasetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'datasets'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, factoryName, datasetName, context);
    }

    private DatasetsClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatasetResourceImpl define(String name) {
        return new DatasetResourceImpl(name, this.manager());
    }
}

