/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.redis.fluent.RedisManagementClient;
import com.azure.resourcemanager.redis.implementation.RedisCachesImpl;
import com.azure.resourcemanager.redis.implementation.RedisManagementClientBuilder;
import com.azure.resourcemanager.redis.models.RedisCaches;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import java.util.Objects;

public final class RedisManager
extends Manager<RedisManagementClient> {
    private RedisCaches redisCaches;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static RedisManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return RedisManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    public static RedisManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new RedisManager(httpPipeline, profile);
    }

    private RedisManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new RedisManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
    }

    public RedisCaches redisCaches() {
        if (this.redisCaches == null) {
            this.redisCaches = new RedisCachesImpl(this);
        }
        return this.redisCaches;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public RedisManager authenticate(TokenCredential credential, AzureProfile profile) {
            return RedisManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public RedisManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

