/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientFactory;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientImpl;
import io.fabric8.kubernetes.client.okhttp.OkHttpRequestImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

class OkHttpClientBuilderImpl
implements HttpClient.Builder {
    private boolean streaming;
    private OkHttpClient.Builder builder;
    private OkHttpClientFactory factory;

    public OkHttpClientBuilderImpl(OkHttpClient.Builder newBuilder, OkHttpClientFactory factory) {
        this.builder = newBuilder;
        this.factory = factory;
    }

    public OkHttpClientImpl build() {
        OkHttpClient client = this.builder.build();
        if (this.streaming) {
            for (Interceptor i : client.networkInterceptors()) {
                if (!(i instanceof HttpLoggingInterceptor)) continue;
                HttpLoggingInterceptor interceptor = (HttpLoggingInterceptor)i;
                interceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
            }
        }
        return new OkHttpClientImpl(client, this.factory);
    }

    public HttpClient.Builder readTimeout(long readTimeout, TimeUnit unit) {
        this.builder.readTimeout(readTimeout, unit);
        return this;
    }

    public HttpClient.Builder connectTimeout(long connectTimeout, TimeUnit unit) {
        this.builder.connectTimeout(connectTimeout, unit);
        return this;
    }

    public HttpClient.Builder writeTimeout(long timeout, TimeUnit timeoutUnit) {
        this.builder.writeTimeout(timeout, timeoutUnit);
        return this;
    }

    public HttpClient.Builder forStreaming() {
        this.builder.cache(null);
        this.streaming = true;
        return this;
    }

    public HttpClient.Builder addOrReplaceInterceptor(String name, io.fabric8.kubernetes.client.http.Interceptor interceptor) {
        List interceptors = this.builder.interceptors();
        for (int i = 0; i < interceptors.size(); ++i) {
            InteceptorAdapter adapter;
            Interceptor exiting = (Interceptor)interceptors.get(i);
            if (!(exiting instanceof InteceptorAdapter) || !(adapter = (InteceptorAdapter)exiting).getName().equals(name)) continue;
            if (interceptor == null) {
                interceptors.remove(i);
            } else {
                interceptors.set(i, new InteceptorAdapter(interceptor, name));
            }
            return this;
        }
        if (interceptor != null) {
            this.builder.addInterceptor((Interceptor)new InteceptorAdapter(interceptor, name));
        }
        return this;
    }

    public HttpClient.Builder authenticatorNone() {
        this.builder.authenticator(Authenticator.NONE);
        return this;
    }

    public HttpClient.Builder sslContext(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        X509TrustManager trustManager = null;
        if (trustManagers != null && trustManagers.length == 1) {
            trustManager = (X509TrustManager)trustManagers[0];
        }
        SSLContext sslContext = SSLUtils.sslContext((KeyManager[])keyManagers, (TrustManager[])trustManagers);
        this.builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
        return this;
    }

    public HttpClient.Builder followAllRedirects() {
        this.builder.followRedirects(true).followSslRedirects(true);
        return this;
    }

    public HttpClient.Builder proxyAddress(InetSocketAddress proxyAddress) {
        if (proxyAddress == null) {
            this.builder.proxy(Proxy.NO_PROXY);
        } else {
            this.builder.proxy(new Proxy(Proxy.Type.HTTP, proxyAddress));
        }
        return this;
    }

    public HttpClient.Builder proxyAuthorization(String credentials) {
        this.builder.proxyAuthenticator((route, response) -> response.request().newBuilder().header("Proxy-Authorization", credentials).build());
        return this;
    }

    public HttpClient.Builder tlsVersions(TlsVersion ... tlsVersions) {
        ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions((okhttp3.TlsVersion[])Arrays.asList(tlsVersions).stream().map(tls -> okhttp3.TlsVersion.valueOf((String)tls.name())).toArray(okhttp3.TlsVersion[]::new)).build();
        this.builder.connectionSpecs(Arrays.asList(spec, ConnectionSpec.CLEARTEXT));
        return this;
    }

    public HttpClient.Builder preferHttp11() {
        this.builder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        return this;
    }

    static final class InteceptorAdapter
    implements Interceptor {
        private final io.fabric8.kubernetes.client.http.Interceptor interceptor;
        private final String name;

        InteceptorAdapter(io.fabric8.kubernetes.client.http.Interceptor interceptor, String name) {
            this.interceptor = interceptor;
            this.name = name;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request.Builder requestBuilder = chain.request().newBuilder();
            OkHttpRequestImpl.BuilderImpl builderImpl = new OkHttpRequestImpl.BuilderImpl(requestBuilder);
            this.interceptor.before((BasicBuilder)new OkHttpRequestImpl.BuilderImpl(requestBuilder), (HttpHeaders)new OkHttpRequestImpl(chain.request()));
            Response response = chain.proceed(requestBuilder.build());
            if (!response.isSuccessful()) {
                try {
                    boolean call = (Boolean)this.interceptor.afterFailure((HttpRequest.Builder)builderImpl, new OkHttpClientImpl.OkHttpResponseImpl<InputStream>(response, InputStream.class)).get();
                    if (call) {
                        response.close();
                        return chain.proceed(requestBuilder.build());
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    throw KubernetesClientException.launderThrowable((Throwable)e);
                }
            }
            return response;
        }

        public String getName() {
            return this.name;
        }
    }
}

