/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.ApplicationGatewaysClient;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.ApplicationGatewaySkuName;
import com.azure.resourcemanager.network.models.ApplicationGateways;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.fluentcore.exception.AggregatedManagementException;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ApplicationGatewaysImpl
extends TopLevelModifiableResourcesImpl<ApplicationGateway, ApplicationGatewayImpl, ApplicationGatewayInner, ApplicationGatewaysClient, NetworkManager>
implements ApplicationGateways {
    public ApplicationGatewaysImpl(NetworkManager networkManager) {
        super((InnerSupportsListing)((NetworkManagementClient)networkManager.serviceClient()).getApplicationGateways(), (Manager)networkManager);
    }

    public ApplicationGatewayImpl define(String name) {
        return this.wrapModel(name).withSize(ApplicationGatewaySkuName.STANDARD_SMALL).withInstanceCount(1);
    }

    protected ApplicationGatewayImpl wrapModel(String name) {
        ApplicationGatewayInner inner = new ApplicationGatewayInner();
        return new ApplicationGatewayImpl(name, inner, (NetworkManager)this.manager());
    }

    protected ApplicationGatewayImpl wrapModel(ApplicationGatewayInner inner) {
        return inner == null ? null : new ApplicationGatewayImpl(inner.name(), inner, (NetworkManager)this.manager());
    }

    @Override
    public void start(String ... applicationGatewayResourceId) {
        if (applicationGatewayResourceId == null) {
            return;
        }
        this.startAsync(applicationGatewayResourceId).blockLast();
    }

    @Override
    public Flux<String> startAsync(String ... applicationGatewayResourceId) {
        return this.startAsync(new ArrayList<String>(Arrays.asList(applicationGatewayResourceId)));
    }

    @Override
    public void stop(String ... applicationGatewayResourceIds) {
        if (applicationGatewayResourceIds == null) {
            return;
        }
        this.stopAsync(applicationGatewayResourceIds).blockLast();
    }

    @Override
    public void start(Collection<String> applicationGatewayResourceIds) {
        this.startAsync(applicationGatewayResourceIds).blockLast();
    }

    @Override
    public void stop(Collection<String> applicationGatewayResourceIds) {
        this.stopAsync(applicationGatewayResourceIds).blockLast();
    }

    @Override
    public Flux<String> stopAsync(String ... applicationGatewayResourceIds) {
        return this.stopAsync(new ArrayList<String>(Arrays.asList(applicationGatewayResourceIds)));
    }

    @Override
    public Flux<String> startAsync(Collection<String> applicationGatewayResourceIds) {
        if (applicationGatewayResourceIds == null) {
            return Flux.empty();
        }
        return Flux.fromIterable(applicationGatewayResourceIds).flatMapDelayError(id -> {
            String resourceGroupName = ResourceUtils.groupFromResourceId((String)id);
            String name = ResourceUtils.nameFromResourceId((String)id);
            return ((ApplicationGatewaysClient)this.inner()).startAsync(resourceGroupName, name).then(Mono.just((Object)id));
        }, 32, 32).onErrorMap(AggregatedManagementException::convertToManagementException).subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler());
    }

    @Override
    public Flux<String> stopAsync(Collection<String> applicationGatewayResourceIds) {
        if (applicationGatewayResourceIds == null) {
            return Flux.empty();
        }
        return Flux.fromIterable(applicationGatewayResourceIds).flatMapDelayError(id -> {
            String resourceGroupName = ResourceUtils.groupFromResourceId((String)id);
            String name = ResourceUtils.nameFromResourceId((String)id);
            return ((ApplicationGatewaysClient)this.inner()).stopAsync(resourceGroupName, name).then(Mono.just((Object)id));
        }, 32, 32).onErrorMap(AggregatedManagementException::convertToManagementException).subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler());
    }
}

