/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.PrivateDnsZoneGroupInner;
import com.azure.resourcemanager.network.implementation.PrivateEndpointImpl;
import com.azure.resourcemanager.network.models.PrivateDnsZoneConfig;
import com.azure.resourcemanager.network.models.PrivateDnsZoneGroup;
import com.azure.resourcemanager.network.models.PrivateEndpoint;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.IndependentChildImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Mono;

class PrivateDnsZoneGroupImpl
extends IndependentChildImpl<PrivateDnsZoneGroup, PrivateEndpoint, PrivateDnsZoneGroupInner, PrivateDnsZoneGroupImpl, NetworkManager>
implements PrivateDnsZoneGroup,
PrivateDnsZoneGroup.Definition,
PrivateDnsZoneGroup.Update {
    private final PrivateEndpointImpl parent;

    protected PrivateDnsZoneGroupImpl(String name, PrivateDnsZoneGroupInner innerModel, PrivateEndpointImpl parent) {
        super(name, (Object)innerModel, (Object)((NetworkManager)parent.manager()));
        this.parent = parent;
    }

    @Override
    public PrivateDnsZoneGroupImpl withPrivateDnsZoneConfigure(String name, String privateDnsZoneId) {
        if (((PrivateDnsZoneGroupInner)((Object)this.innerModel())).privateDnsZoneConfigs() == null) {
            ((PrivateDnsZoneGroupInner)((Object)this.innerModel())).withPrivateDnsZoneConfigs(new ArrayList<PrivateDnsZoneConfig>());
        }
        ((PrivateDnsZoneGroupInner)((Object)this.innerModel())).privateDnsZoneConfigs().add(new PrivateDnsZoneConfig().withName(name).withPrivateDnsZoneId(privateDnsZoneId));
        return this;
    }

    @Override
    public PrivateDnsZoneGroup.Update withoutPrivateDnsZoneConfigure(String name) {
        if (((PrivateDnsZoneGroupInner)((Object)this.innerModel())).privateDnsZoneConfigs() != null) {
            ((PrivateDnsZoneGroupInner)((Object)this.innerModel())).privateDnsZoneConfigs().removeIf(config -> config.name().equals(name));
        }
        return this;
    }

    public String id() {
        return ((PrivateDnsZoneGroupInner)((Object)this.innerModel())).id();
    }

    protected Mono<PrivateDnsZoneGroup> createChildResourceAsync() {
        return ((NetworkManagementClient)((NetworkManager)((Object)this.manager())).serviceClient()).getPrivateDnsZoneGroups().createOrUpdateAsync(this.parent.resourceGroupName(), this.parent.name(), this.name(), (PrivateDnsZoneGroupInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<PrivateDnsZoneGroupInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)((Object)this.manager())).serviceClient()).getPrivateDnsZoneGroups().getAsync(this.parent.resourceGroupName(), this.parent.name(), this.name());
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((PrivateDnsZoneGroupInner)((Object)this.innerModel())).provisioningState();
    }

    @Override
    public List<PrivateDnsZoneConfig> privateDnsZoneConfigures() {
        if (((PrivateDnsZoneGroupInner)((Object)this.innerModel())).privateDnsZoneConfigs() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(((PrivateDnsZoneGroupInner)((Object)this.innerModel())).privateDnsZoneConfigs());
    }
}

