/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasName;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyCurveName;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyType;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public interface Key
extends Indexable,
HasInnerModel<KeyProperties>,
HasId,
HasName,
Updatable<Update> {
    public JsonWebKey getJsonWebKey();

    public Mono<JsonWebKey> getJsonWebKeyAsync();

    public KeyProperties attributes();

    public Map<String, String> tags();

    public boolean managed();

    public PagedIterable<Key> listVersions();

    public PagedFlux<Key> listVersionsAsync();

    public byte[] backup();

    public Mono<byte[]> backupAsync();

    public byte[] encrypt(EncryptionAlgorithm var1, byte[] var2);

    public Mono<byte[]> encryptAsync(EncryptionAlgorithm var1, byte[] var2);

    public byte[] decrypt(EncryptionAlgorithm var1, byte[] var2);

    public Mono<byte[]> decryptAsync(EncryptionAlgorithm var1, byte[] var2);

    public byte[] sign(SignatureAlgorithm var1, byte[] var2);

    public Mono<byte[]> signAsync(SignatureAlgorithm var1, byte[] var2);

    public boolean verify(SignatureAlgorithm var1, byte[] var2, byte[] var3);

    public Mono<Boolean> verifyAsync(SignatureAlgorithm var1, byte[] var2, byte[] var3);

    public byte[] wrapKey(KeyWrapAlgorithm var1, byte[] var2);

    public Mono<byte[]> wrapKeyAsync(KeyWrapAlgorithm var1, byte[] var2);

    public byte[] unwrapKey(KeyWrapAlgorithm var1, byte[] var2);

    public Mono<byte[]> unwrapKeyAsync(KeyWrapAlgorithm var1, byte[] var2);

    public static interface UpdateWithImport
    extends Update,
    UpdateStages.WithHsm {
    }

    public static interface UpdateWithCreate
    extends Update,
    UpdateStages.WithKeySize {
    }

    public static interface Update
    extends Appliable<Key>,
    UpdateStages.WithKey,
    UpdateStages.WithKeyOperations,
    UpdateStages.WithAttributes,
    UpdateStages.WithTags {
    }

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }

        public static interface WithAttributes {
            public Update withAttributes(KeyProperties var1);
        }

        public static interface WithKeyOperations {
            public Update withKeyOperations(List<KeyOperation> var1);

            public Update withKeyOperations(KeyOperation ... var1);
        }

        public static interface WithHsm {
            public UpdateWithImport withHsm(boolean var1);
        }

        public static interface WithKeySize {
            public UpdateWithCreate withKeySize(int var1);
        }

        public static interface WithKey {
            public UpdateWithCreate withKeyTypeToCreate(KeyType var1);

            public UpdateWithImport withLocalKeyToImport(JsonWebKey var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithImport
        extends WithHsm,
        WithCreateBase {
        }

        public static interface WithCreate
        extends WithKeyOperations,
        WithKeySize,
        WithCreateBase {
        }

        public static interface WithCreateBase
        extends Creatable<Key>,
        WithAttributes,
        WithTags {
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithAttributes {
            public WithCreate withAttributes(KeyProperties var1);
        }

        public static interface WithHsm {
            public WithImport withHsm(boolean var1);
        }

        public static interface WithKeyOperations {
            public WithCreate withKeyOperations(List<KeyOperation> var1);

            public WithCreate withKeyOperations(KeyOperation ... var1);
        }

        public static interface WithKeySize {
            public WithCreate withKeySize(int var1);

            public WithCreate withKeyCurveName(KeyCurveName var1);
        }

        public static interface WithKey {
            public WithCreate withKeyTypeToCreate(KeyType var1);

            public WithImport withLocalKeyToImport(JsonWebKey var1);
        }

        public static interface Blank
        extends WithKey {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithKey,
    DefinitionStages.WithImport,
    DefinitionStages.WithCreate {
    }
}

