/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1beta1IDRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="RunAsGroupStrategyOptions defines the strategy type and any options used to create the strategy.")
public class V1beta1RunAsGroupStrategyOptions {
    public static final String SERIALIZED_NAME_RANGES = "ranges";
    @SerializedName(value="ranges")
    private List<V1beta1IDRange> ranges = null;
    public static final String SERIALIZED_NAME_RULE = "rule";
    @SerializedName(value="rule")
    private String rule;

    public V1beta1RunAsGroupStrategyOptions ranges(List<V1beta1IDRange> ranges) {
        this.ranges = ranges;
        return this;
    }

    public V1beta1RunAsGroupStrategyOptions addRangesItem(V1beta1IDRange rangesItem) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<V1beta1IDRange>();
        }
        this.ranges.add(rangesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ranges are the allowed ranges of gids that may be used. If you would like to force a single gid then supply a single range with the same start and end. Required for MustRunAs.")
    public List<V1beta1IDRange> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<V1beta1IDRange> ranges) {
        this.ranges = ranges;
    }

    public V1beta1RunAsGroupStrategyOptions rule(String rule) {
        this.rule = rule;
        return this;
    }

    @ApiModelProperty(required=true, value="rule is the strategy that will dictate the allowable RunAsGroup values that may be set.")
    public String getRule() {
        return this.rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1RunAsGroupStrategyOptions v1beta1RunAsGroupStrategyOptions = (V1beta1RunAsGroupStrategyOptions)o;
        return Objects.equals(this.ranges, v1beta1RunAsGroupStrategyOptions.ranges) && Objects.equals(this.rule, v1beta1RunAsGroupStrategyOptions.rule);
    }

    public int hashCode() {
        return Objects.hash(this.ranges, this.rule);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1RunAsGroupStrategyOptions {\n");
        sb.append("    ranges: ").append(this.toIndentedString(this.ranges)).append("\n");
        sb.append("    rule: ").append(this.toIndentedString(this.rule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

