/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1Condition;
import io.kubernetes.client.openapi.models.V1ConditionBuilder;
import io.kubernetes.client.openapi.models.V1ConditionFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha1TypeChecking;
import io.kubernetes.client.openapi.models.V1alpha1TypeCheckingBuilder;
import io.kubernetes.client.openapi.models.V1alpha1TypeCheckingFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha1ValidatingAdmissionPolicyStatus;
import io.kubernetes.client.openapi.models.V1alpha1ValidatingAdmissionPolicyStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha1ValidatingAdmissionPolicyStatusFluentImpl<A extends V1alpha1ValidatingAdmissionPolicyStatusFluent<A>>
extends BaseFluent<A>
implements V1alpha1ValidatingAdmissionPolicyStatusFluent<A> {
    private ArrayList<V1ConditionBuilder> conditions;
    private Long observedGeneration;
    private V1alpha1TypeCheckingBuilder typeChecking;

    public V1alpha1ValidatingAdmissionPolicyStatusFluentImpl() {
    }

    public V1alpha1ValidatingAdmissionPolicyStatusFluentImpl(V1alpha1ValidatingAdmissionPolicyStatus instance) {
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withTypeChecking(instance.getTypeChecking());
        }
    }

    @Override
    public A addToConditions(int index, V1Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1ConditionBuilder builder = new V1ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToConditions(int index, V1Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1ConditionBuilder builder = new V1ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1Condition ... items) {
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1Condition> items) {
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<V1ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1ConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Condition> getConditions() {
        return this.conditions != null ? V1alpha1ValidatingAdmissionPolicyStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<V1Condition> buildConditions() {
        return this.conditions != null ? V1alpha1ValidatingAdmissionPolicyStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public V1Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1Condition buildMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        for (V1ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        for (V1ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<V1Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (V1Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyStatusFluent.ConditionsNested<A> addNewConditionLike(V1Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyStatusFluent.ConditionsNested<A> setNewConditionLike(int index, V1Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    @Deprecated
    public V1alpha1TypeChecking getTypeChecking() {
        return this.typeChecking != null ? this.typeChecking.build() : null;
    }

    @Override
    public V1alpha1TypeChecking buildTypeChecking() {
        return this.typeChecking != null ? this.typeChecking.build() : null;
    }

    @Override
    public A withTypeChecking(V1alpha1TypeChecking typeChecking) {
        this._visitables.get("typeChecking").remove(this.typeChecking);
        if (typeChecking != null) {
            this.typeChecking = new V1alpha1TypeCheckingBuilder(typeChecking);
            this._visitables.get("typeChecking").add(this.typeChecking);
        } else {
            this.typeChecking = null;
            this._visitables.get("typeChecking").remove(this.typeChecking);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTypeChecking() {
        return this.typeChecking != null;
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyStatusFluent.TypeCheckingNested<A> withNewTypeChecking() {
        return new TypeCheckingNestedImpl();
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyStatusFluent.TypeCheckingNested<A> withNewTypeCheckingLike(V1alpha1TypeChecking item) {
        return new TypeCheckingNestedImpl(item);
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyStatusFluent.TypeCheckingNested<A> editTypeChecking() {
        return this.withNewTypeCheckingLike(this.getTypeChecking());
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyStatusFluent.TypeCheckingNested<A> editOrNewTypeChecking() {
        return this.withNewTypeCheckingLike(this.getTypeChecking() != null ? this.getTypeChecking() : new V1alpha1TypeCheckingBuilder().build());
    }

    @Override
    public V1alpha1ValidatingAdmissionPolicyStatusFluent.TypeCheckingNested<A> editOrNewTypeCheckingLike(V1alpha1TypeChecking item) {
        return this.withNewTypeCheckingLike(this.getTypeChecking() != null ? this.getTypeChecking() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha1ValidatingAdmissionPolicyStatusFluentImpl that = (V1alpha1ValidatingAdmissionPolicyStatusFluentImpl)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        return Objects.equals(this.typeChecking, that.typeChecking);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.observedGeneration, this.typeChecking, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.typeChecking != null) {
            sb.append("typeChecking:");
            sb.append(this.typeChecking);
        }
        sb.append("}");
        return sb.toString();
    }

    class ConditionsNestedImpl<N>
    extends V1ConditionFluentImpl<V1alpha1ValidatingAdmissionPolicyStatusFluent.ConditionsNested<N>>
    implements V1alpha1ValidatingAdmissionPolicyStatusFluent.ConditionsNested<N>,
    Nested<N> {
        V1ConditionBuilder builder;
        int index;

        ConditionsNestedImpl(int index, V1Condition item) {
            this.index = index;
            this.builder = new V1ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1ConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1ValidatingAdmissionPolicyStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    class TypeCheckingNestedImpl<N>
    extends V1alpha1TypeCheckingFluentImpl<V1alpha1ValidatingAdmissionPolicyStatusFluent.TypeCheckingNested<N>>
    implements V1alpha1ValidatingAdmissionPolicyStatusFluent.TypeCheckingNested<N>,
    Nested<N> {
        V1alpha1TypeCheckingBuilder builder;

        TypeCheckingNestedImpl(V1alpha1TypeChecking item) {
            this.builder = new V1alpha1TypeCheckingBuilder(this, item);
        }

        TypeCheckingNestedImpl() {
            this.builder = new V1alpha1TypeCheckingBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1ValidatingAdmissionPolicyStatusFluentImpl.this.withTypeChecking(this.builder.build());
        }

        @Override
        public N endTypeChecking() {
            return this.and();
        }
    }
}

