/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.controller;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.controller.ControllerWatch;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.workqueue.WorkQueue;
import io.kubernetes.client.informer.ResourceEventHandler;
import java.time.Duration;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public class DefaultControllerWatch<ApiType extends KubernetesObject>
implements ControllerWatch<ApiType> {
    private final WorkQueue<Request> workQueue;
    private final Function<ApiType, Request> workKeyGenerator;
    private Class<ApiType> apiTypeClass;
    private Predicate<ApiType> onAddFilterPredicate;
    private BiPredicate<ApiType, ApiType> onUpdateFilterPredicate;
    private BiPredicate<ApiType, Boolean> onDeleteFilterPredicate;
    private Duration resyncPeriod;

    public DefaultControllerWatch(Class<ApiType> apiTypeClass, WorkQueue<Request> workQueue, Function<ApiType, Request> workKeyGenerator, Duration resyncPeriod) {
        this.workQueue = workQueue;
        this.apiTypeClass = apiTypeClass;
        this.workKeyGenerator = workKeyGenerator;
        this.resyncPeriod = resyncPeriod;
    }

    public Predicate<ApiType> getOnAddFilterPredicate() {
        return this.onAddFilterPredicate;
    }

    public void setOnAddFilterPredicate(Predicate<ApiType> onAddFilterPredicate) {
        this.onAddFilterPredicate = onAddFilterPredicate;
    }

    public BiPredicate<ApiType, ApiType> getOnUpdateFilterPredicate() {
        return this.onUpdateFilterPredicate;
    }

    public void setOnUpdateFilterPredicate(BiPredicate<ApiType, ApiType> onUpdateFilterPredicate) {
        this.onUpdateFilterPredicate = onUpdateFilterPredicate;
    }

    public BiPredicate<ApiType, Boolean> getOnDeleteFilterPredicate() {
        return this.onDeleteFilterPredicate;
    }

    public void setOnDeleteFilterPredicate(BiPredicate<ApiType, Boolean> onDeleteFilterPredicate) {
        this.onDeleteFilterPredicate = onDeleteFilterPredicate;
    }

    public Class<ApiType> getApiTypeClass() {
        return this.apiTypeClass;
    }

    @Override
    public Class<ApiType> getResourceClass() {
        return this.apiTypeClass;
    }

    @Override
    public ResourceEventHandler<ApiType> getResourceEventHandler() {
        return new ResourceEventHandler<ApiType>(){

            public void onAdd(ApiType obj) {
                Request req;
                if ((DefaultControllerWatch.this.onAddFilterPredicate == null || DefaultControllerWatch.this.onAddFilterPredicate.test(obj)) && null != (req = (Request)DefaultControllerWatch.this.workKeyGenerator.apply(obj))) {
                    DefaultControllerWatch.this.workQueue.add(req);
                }
            }

            public void onUpdate(ApiType oldObj, ApiType newObj) {
                Request req;
                if ((DefaultControllerWatch.this.onUpdateFilterPredicate == null || DefaultControllerWatch.this.onUpdateFilterPredicate.test(oldObj, newObj)) && null != (req = (Request)DefaultControllerWatch.this.workKeyGenerator.apply(newObj))) {
                    DefaultControllerWatch.this.workQueue.add(req);
                }
            }

            public void onDelete(ApiType obj, boolean deletedFinalStateUnknown) {
                Request req;
                if ((DefaultControllerWatch.this.onDeleteFilterPredicate == null || DefaultControllerWatch.this.onDeleteFilterPredicate.test(obj, deletedFinalStateUnknown)) && null != (req = (Request)DefaultControllerWatch.this.workKeyGenerator.apply(obj))) {
                    DefaultControllerWatch.this.workQueue.add(req);
                }
            }
        };
    }

    @Override
    public Duration getResyncPeriod() {
        return this.resyncPeriod;
    }
}

