/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.storage.GapicWritableByteChannelSessionBuilder;
import com.google.cloud.storage.ResumableWrite;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import java.util.concurrent.Executor;
import java.util.function.Function;

final class GapicUploadSessionBuilder {
    private GapicUploadSessionBuilder() {
    }

    static GapicUploadSessionBuilder create() {
        return new GapicUploadSessionBuilder();
    }

    GapicWritableByteChannelSessionBuilder byteChannel(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write) {
        return new GapicWritableByteChannelSessionBuilder(write);
    }

    ApiFuture<ResumableWrite> resumableWrite(UnaryCallable<StartResumableWriteRequest, StartResumableWriteResponse> x, WriteObjectRequest writeObjectRequest) {
        StartResumableWriteRequest.Builder b = StartResumableWriteRequest.newBuilder();
        if (writeObjectRequest.hasWriteObjectSpec()) {
            b.setWriteObjectSpec(writeObjectRequest.getWriteObjectSpec());
        }
        if (writeObjectRequest.hasCommonObjectRequestParams()) {
            b.setCommonObjectRequestParams(writeObjectRequest.getCommonObjectRequestParams());
        }
        if (writeObjectRequest.hasObjectChecksums()) {
            b.setObjectChecksums(writeObjectRequest.getObjectChecksums());
        }
        StartResumableWriteRequest req = b.build();
        Function<String, WriteObjectRequest> f = uploadId -> writeObjectRequest.toBuilder().clearWriteObjectSpec().setUploadId(uploadId).build();
        return ApiFutures.transform((ApiFuture)x.futureCall((Object)req), resp -> new ResumableWrite(req, (StartResumableWriteResponse)resp, f), (Executor)MoreExecutors.directExecutor());
    }
}

