/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.CastedLiteralOperandTypeCheckers;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.util.Optionality;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.NativelySupportsDistinct;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class ArrayConcatSqlAggregator
implements SqlAggregator {
    private static final String NAME = "ARRAY_CONCAT_AGG";
    private static final SqlAggFunction FUNCTION = new ArrayConcatAggFunction();

    @Override
    public SqlAggFunction calciteFunction() {
        return FUNCTION;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        String fieldName;
        List<RexNode> arguments = inputAccessor.getFields(aggregateCall.getArgList());
        Integer maxSizeBytes = null;
        if (arguments.size() > 1) {
            RexNode maxBytes = arguments.get(1);
            if (!maxBytes.isA(SqlKind.LITERAL)) {
                return null;
            }
            maxSizeBytes = ((Number)((Object)RexLiteral.value((RexNode)maxBytes))).intValue();
        }
        DruidExpression arg = Expressions.toDruidExpression(plannerContext, inputAccessor.getInputRowSignature(), arguments.get(0));
        ExprMacroTable macroTable = plannerContext.getPlannerToolbox().exprMacroTable();
        ColumnType druidType = Calcites.getValueTypeForRelDataTypeFull(aggregateCall.getType());
        if (druidType == null || !druidType.isArray()) {
            return null;
        }
        String initialvalue = ExpressionType.fromColumnTypeStrict((TypeSignature)druidType).asTypeString() + "[]";
        if (arg.isDirectColumnAccess()) {
            fieldName = arg.getDirectColumn();
        } else {
            VirtualColumn vc = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(plannerContext, arg, druidType);
            fieldName = vc.getOutputName();
        }
        if (aggregateCall.isDistinct()) {
            return Aggregation.create((AggregatorFactory)new ExpressionLambdaAggregatorFactory(name, (Set)ImmutableSet.of((Object)fieldName), null, initialvalue, null, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), StringUtils.format((String)"array_set_add_all(\"__acc\", \"%s\")", (Object[])new Object[]{fieldName}), StringUtils.format((String)"array_set_add_all(\"__acc\", \"%s\")", (Object[])new Object[]{name}), null, null, maxSizeBytes != null ? new HumanReadableBytes((long)maxSizeBytes.intValue()) : null, macroTable));
        }
        return Aggregation.create((AggregatorFactory)new ExpressionLambdaAggregatorFactory(name, (Set)ImmutableSet.of((Object)fieldName), null, initialvalue, null, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), StringUtils.format((String)"array_concat(\"__acc\", \"%s\")", (Object[])new Object[]{fieldName}), StringUtils.format((String)"array_concat(\"__acc\", \"%s\")", (Object[])new Object[]{name}), null, null, maxSizeBytes != null ? new HumanReadableBytes((long)maxSizeBytes.intValue()) : null, macroTable));
    }

    @NativelySupportsDistinct
    private static class ArrayConcatAggFunction
    extends SqlAggFunction {
        ArrayConcatAggFunction() {
            super(ArrayConcatSqlAggregator.NAME, null, SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0, InferTypes.ANY_NULLABLE, OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.ARRAY, OperandTypes.sequence((String)StringUtils.format((String)"'%s(expr, maxSizeBytes)'", (Object[])new Object[]{ArrayConcatSqlAggregator.NAME}), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ARRAY, CastedLiteralOperandTypeCheckers.POSITIVE_INTEGER_LITERAL})}), SqlFunctionCategory.USER_DEFINED_FUNCTION, false, false, Optionality.IGNORED);
        }
    }
}

