/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.FieldPositionHelper;
import org.apache.druid.frame.field.NumericFieldReader;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.field.TransformUtils;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DoubleColumnSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;

public class DoubleFieldReader
extends NumericFieldReader {
    private final FrameType frameType;

    public static DoubleFieldReader forPrimitive(FrameType frameType) {
        return new DoubleFieldReader(false, frameType);
    }

    public static DoubleFieldReader forArray(FrameType frameType) {
        return new DoubleFieldReader(true, frameType);
    }

    private DoubleFieldReader(boolean forArray, FrameType frameType) {
        super(forArray);
        this.frameType = frameType;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.DOUBLE;
    }

    @Override
    public ColumnValueSelector<?> getColumnValueSelector(Memory memory, ReadableFieldPointer fieldPointer, byte nullIndicatorByte) {
        return new DoubleFieldSelector(memory, fieldPointer, nullIndicatorByte, this.frameType);
    }

    @Override
    public Column makeRACColumn(Frame frame, RowSignature signature, String columnName) {
        return new DoubleFieldReaderColumn(frame, signature.indexOf(columnName), signature.size());
    }

    private static class DoubleFieldSelector
    extends NumericFieldReader.Selector
    implements DoubleColumnSelector {
        final Memory dataRegion;
        final ReadableFieldPointer fieldPointer;
        final FrameType frameType;

        public DoubleFieldSelector(Memory dataRegion, ReadableFieldPointer fieldPointer, byte nullIndicatorByte, FrameType frameType) {
            super(dataRegion, fieldPointer, nullIndicatorByte);
            this.dataRegion = dataRegion;
            this.fieldPointer = fieldPointer;
            this.frameType = frameType;
        }

        @Override
        public double getDouble() {
            assert (!this.isNull());
            long bits = this.dataRegion.getLong(this.fieldPointer.position() + 1L);
            return TransformUtils.detransformToDouble(bits, this.frameType);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        @Override
        public boolean isNull() {
            return super._isNull();
        }
    }

    private class DoubleFieldReaderColumn
    implements Column {
        private final Frame frame;
        private final Memory dataRegion;
        private final FieldPositionHelper coach;

        public DoubleFieldReaderColumn(Frame frame, int columnIndex, int numFields) {
            this.frame = frame;
            this.dataRegion = frame.region(1);
            this.coach = new FieldPositionHelper(frame, frame.region(0), this.dataRegion, columnIndex, numFields);
        }

        @Override
        @Nonnull
        public ColumnAccessor toAccessor() {
            return new ColumnAccessor(){

                @Override
                public ColumnType getType() {
                    return ColumnType.DOUBLE;
                }

                @Override
                public int numRows() {
                    return DoubleFieldReaderColumn.this.frame.numRows();
                }

                @Override
                public boolean isNull(int rowNum) {
                    long fieldPosition = DoubleFieldReaderColumn.this.coach.computeFieldPosition(rowNum);
                    return DoubleFieldReaderColumn.this.dataRegion.getByte(fieldPosition) == DoubleFieldReader.this.getNullIndicatorByte();
                }

                @Override
                @Nullable
                public Object getObject(int rowNum) {
                    long fieldPosition = DoubleFieldReaderColumn.this.coach.computeFieldPosition(rowNum);
                    if (DoubleFieldReaderColumn.this.dataRegion.getByte(fieldPosition) == DoubleFieldReader.this.getNullIndicatorByte()) {
                        return null;
                    }
                    return this.getDoubleAtPosition(fieldPosition);
                }

                @Override
                public double getDouble(int rowNum) {
                    long fieldPosition = DoubleFieldReaderColumn.this.coach.computeFieldPosition(rowNum);
                    if (DoubleFieldReaderColumn.this.dataRegion.getByte(fieldPosition) == DoubleFieldReader.this.getNullIndicatorByte()) {
                        return 0.0;
                    }
                    return this.getDoubleAtPosition(fieldPosition);
                }

                @Override
                public float getFloat(int rowNum) {
                    return (float)this.getDouble(rowNum);
                }

                @Override
                public long getLong(int rowNum) {
                    return (long)this.getDouble(rowNum);
                }

                @Override
                public int getInt(int rowNum) {
                    return (int)this.getDouble(rowNum);
                }

                @Override
                public int compareRows(int lhsRowNum, int rhsRowNum) {
                    long lhsPosition = DoubleFieldReaderColumn.this.coach.computeFieldPosition(lhsRowNum);
                    long rhsPosition = DoubleFieldReaderColumn.this.coach.computeFieldPosition(rhsRowNum);
                    byte nullIndicatorByte = DoubleFieldReader.this.getNullIndicatorByte();
                    if (DoubleFieldReaderColumn.this.dataRegion.getByte(lhsPosition) == nullIndicatorByte) {
                        if (DoubleFieldReaderColumn.this.dataRegion.getByte(rhsPosition) == nullIndicatorByte) {
                            return 0;
                        }
                        return -1;
                    }
                    if (DoubleFieldReaderColumn.this.dataRegion.getByte(rhsPosition) == nullIndicatorByte) {
                        return 1;
                    }
                    return Double.compare(this.getDoubleAtPosition(lhsPosition), this.getDoubleAtPosition(rhsPosition));
                }

                private double getDoubleAtPosition(long lhsPosition) {
                    return TransformUtils.detransformToDouble(DoubleFieldReaderColumn.this.dataRegion.getLong(lhsPosition + 1L), DoubleFieldReader.this.frameType);
                }
            };
        }

        @Override
        @Nullable
        public <T> T as(Class<? extends T> clazz) {
            return null;
        }
    }
}

