/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.CaseSearchedFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.ExprEvalDoubleVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public final class CaseSearchedDoubleVectorProcessor
extends CaseSearchedFunctionVectorProcessor<double[]> {
    private final double[] output;
    private final boolean[] outputNulls;

    public CaseSearchedDoubleVectorProcessor(ExprVectorProcessor<?>[] conditionProcessors, ExprVectorProcessor<double[]>[] thenProcessors) {
        super(ExpressionType.DOUBLE, conditionProcessors, thenProcessors);
        this.output = new double[conditionProcessors[0].maxVectorSize()];
        this.outputNulls = new boolean[conditionProcessors[0].maxVectorSize()];
    }

    @Override
    protected void processThenVector(ExprEvalVector<double[]> thenVector, int currentMatches, int[] thenSelection) {
        double[] thenValues = thenVector.getDoubleVector();
        boolean[] thenNulls = thenVector.getNullVector();
        for (int i = 0; i < currentMatches; ++i) {
            int outIndex = thenSelection[i];
            this.output[outIndex] = thenValues[i];
            this.outputNulls[outIndex] = thenNulls != null ? thenNulls[i] : false;
        }
    }

    @Override
    protected void processElseVector(ExprEvalVector<double[]> elseVector, int[] conditionSelection) {
        double[] elseValues = elseVector.getDoubleVector();
        boolean[] elseNulls = elseVector.getNullVector();
        for (int i = 0; i < this.conditionBindingFilterer.getCurrentVectorSize(); ++i) {
            int outIndex = conditionSelection[i];
            this.output[outIndex] = elseValues[i];
            this.outputNulls[outIndex] = elseNulls != null ? elseNulls[i] : false;
        }
    }

    @Override
    protected void processElseNull(int[] conditionSelection) {
        for (int i = 0; i < this.conditionBindingFilterer.getCurrentVectorSize(); ++i) {
            int outIndex = conditionSelection[i];
            this.output[outIndex] = 0.0;
            this.outputNulls[outIndex] = true;
        }
    }

    @Override
    protected ExprEvalVector<double[]> makeResultVector() {
        return new ExprEvalDoubleVector(this.output, this.outputNulls);
    }
}

