/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.segment.data.ColumnCapacityExceededException;
import org.apache.druid.segment.data.CompressedBlockSerializer;
import org.apache.druid.segment.data.CompressedLongsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.file.SegmentFileChannel;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class CompressedVariableSizedBlobColumnSerializer
implements Serializer {
    private static final MetaSerdeHelper<CompressedVariableSizedBlobColumnSerializer> META_SERDE_HELPER = MetaSerdeHelper.firstWriteByte(x -> 1).writeInt(x -> x.numValues);
    private final String filenameBase;
    private final String offsetsFile;
    private final String blobsFile;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final CompressionStrategy compression;
    private int numValues;
    private long currentOffset;
    private CompressedLongsSerializer offsetsSerializer;
    private CompressedBlockSerializer valuesSerializer;

    public CompressedVariableSizedBlobColumnSerializer(String filenameBase, SegmentWriteOutMedium segmentWriteOutMedium, CompressionStrategy compression) {
        this.filenameBase = filenameBase;
        this.offsetsFile = CompressedVariableSizedBlobColumnSerializer.getCompressedOffsetsFileName(filenameBase);
        this.blobsFile = CompressedVariableSizedBlobColumnSerializer.getCompressedBlobsFileName(filenameBase);
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.compression = compression;
        this.numValues = 0;
    }

    public void open() throws IOException {
        this.numValues = 0;
        this.currentOffset = 0L;
        this.offsetsSerializer = new CompressedLongsSerializer(this.segmentWriteOutMedium, this.compression, this.segmentWriteOutMedium.getCloser());
        this.offsetsSerializer.open();
        this.valuesSerializer = new CompressedBlockSerializer(this.segmentWriteOutMedium, this.compression, 65536, this.segmentWriteOutMedium.getCloser());
        this.valuesSerializer.open();
    }

    public void addValue(byte[] bytes) throws IOException {
        this.valuesSerializer.addValue(bytes);
        this.currentOffset += (long)bytes.length;
        this.offsetsSerializer.add(this.currentOffset);
        ++this.numValues;
        if (this.numValues < 0) {
            throw new ColumnCapacityExceededException(this.filenameBase);
        }
    }

    public void addValue(ByteBuffer bytes) throws IOException {
        this.currentOffset += (long)bytes.remaining();
        this.valuesSerializer.addValue(bytes);
        this.offsetsSerializer.add(this.currentOffset);
        ++this.numValues;
        if (this.numValues < 0) {
            throw new ColumnCapacityExceededException(this.filenameBase);
        }
    }

    @Override
    public long getSerializedSize() {
        return META_SERDE_HELPER.size(this);
    }

    @Override
    public void writeTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
        META_SERDE_HELPER.writeTo(channel, this);
        try (SegmentFileChannel sub = fileBuilder.addWithChannel(this.offsetsFile, this.offsetsSerializer.getSerializedSize());){
            this.offsetsSerializer.writeTo(sub, fileBuilder);
        }
        sub = fileBuilder.addWithChannel(this.blobsFile, this.valuesSerializer.getSerializedSize());
        try {
            this.valuesSerializer.writeTo(sub, fileBuilder);
        }
        finally {
            if (sub != null) {
                sub.close();
            }
        }
    }

    public static String getCompressedOffsetsFileName(String filenameBase) {
        return filenameBase + "_offsets";
    }

    public static String getCompressedBlobsFileName(String filenameBase) {
        return filenameBase + "_compressed";
    }
}

