/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.BaseState;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.UnsafeUtil;
import org.apache.datasketches.memory.internal.XxHash64;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.data.SafeWritableMemory;

public abstract class SafeWritableBase
implements BaseState {
    static final MemoryRequestServer SAFE_HEAP_REQUEST_SERVER = new HeapByteBufferMemoryRequestServer();
    final ByteBuffer buffer;
    private static final long P1 = -7046029288634856825L;
    private static final long P2 = -4417276706812531889L;
    private static final long P3 = 1609587929392839161L;
    private static final long P4 = -8796714831421723037L;
    private static final long P5 = 2870177450012600261L;

    public SafeWritableBase(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public MemoryRequestServer getMemoryRequestServer() {
        return SAFE_HEAP_REQUEST_SERVER;
    }

    public boolean getBoolean(long offsetBytes) {
        return this.getByte(Ints.checkedCast((long)offsetBytes)) != 0;
    }

    public byte getByte(long offsetBytes) {
        return this.buffer.get(Ints.checkedCast((long)offsetBytes));
    }

    public char getChar(long offsetBytes) {
        return this.buffer.getChar(Ints.checkedCast((long)offsetBytes));
    }

    public double getDouble(long offsetBytes) {
        return this.buffer.getDouble(Ints.checkedCast((long)offsetBytes));
    }

    public float getFloat(long offsetBytes) {
        return this.buffer.getFloat(Ints.checkedCast((long)offsetBytes));
    }

    public int getInt(long offsetBytes) {
        return this.buffer.getInt(Ints.checkedCast((long)offsetBytes));
    }

    public long getLong(long offsetBytes) {
        return this.buffer.getLong(Ints.checkedCast((long)offsetBytes));
    }

    public short getShort(long offsetBytes) {
        return this.buffer.getShort(Ints.checkedCast((long)offsetBytes));
    }

    public void putBoolean(long offsetBytes, boolean value) {
        this.buffer.put(Ints.checkedCast((long)offsetBytes), (byte)(value ? 1 : 0));
    }

    public void putByte(long offsetBytes, byte value) {
        this.buffer.put(Ints.checkedCast((long)offsetBytes), value);
    }

    public void putChar(long offsetBytes, char value) {
        this.buffer.putChar(Ints.checkedCast((long)offsetBytes), value);
    }

    public void putDouble(long offsetBytes, double value) {
        this.buffer.putDouble(Ints.checkedCast((long)offsetBytes), value);
    }

    public void putFloat(long offsetBytes, float value) {
        this.buffer.putFloat(Ints.checkedCast((long)offsetBytes), value);
    }

    public void putInt(long offsetBytes, int value) {
        this.buffer.putInt(Ints.checkedCast((long)offsetBytes), value);
    }

    public void putLong(long offsetBytes, long value) {
        this.buffer.putLong(Ints.checkedCast((long)offsetBytes), value);
    }

    public void putShort(long offsetBytes, short value) {
        this.buffer.putShort(Ints.checkedCast((long)offsetBytes), value);
    }

    public ByteOrder getTypeByteOrder() {
        return this.buffer.order();
    }

    public boolean isByteOrderCompatible(ByteOrder byteOrder) {
        return this.buffer.order().equals(byteOrder);
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public long getCapacity() {
        return this.buffer.capacity();
    }

    public long getCumulativeOffset() {
        return 0L;
    }

    public long getCumulativeOffset(long offsetBytes) {
        return offsetBytes;
    }

    public long getRegionOffset() {
        return 0L;
    }

    public long getRegionOffset(long offsetBytes) {
        return offsetBytes;
    }

    public boolean hasArray() {
        return false;
    }

    public long xxHash64(long offsetBytes, long lengthBytes, long seed) {
        return SafeWritableBase.hash(this.buffer, offsetBytes, lengthBytes, seed);
    }

    public long xxHash64(long in, long seed) {
        return XxHash64.hash((long)in, (long)seed);
    }

    public boolean hasByteBuffer() {
        return true;
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isSameResource(Object that) {
        return this.equals(that);
    }

    public boolean isValid() {
        return true;
    }

    public void checkValidAndBounds(long offsetBytes, long lengthBytes) {
        Preconditions.checkArgument((Ints.checkedCast((long)offsetBytes) < this.buffer.limit() ? 1 : 0) != 0, (String)"start offset %s is greater than buffer limit %s", (long)offsetBytes, (int)this.buffer.limit());
        Preconditions.checkArgument((Ints.checkedCast((long)(offsetBytes + lengthBytes)) < this.buffer.limit() ? 1 : 0) != 0, (String)"end offset %s is greater than buffer limit %s", (long)(offsetBytes + lengthBytes), (int)this.buffer.limit());
    }

    public String toHexString(String header, long offsetBytes, int lengthBytes) {
        String klass = this.getClass().getSimpleName();
        String s1 = StringUtils.format("(..., %d, %d)", offsetBytes, lengthBytes);
        long hcode = (long)this.hashCode() & 0xFFFFFFFFL;
        String call = ".toHexString" + s1 + ", hashCode: " + hcode;
        String sb = "### " + klass + " SUMMARY ###" + UnsafeUtil.LS + "Header Comment      : " + header + UnsafeUtil.LS + "Call Parameters     : " + call;
        return SafeWritableBase.toHex(this, sb, offsetBytes, lengthBytes);
    }

    static String toHex(SafeWritableBase state, String preamble, long offsetBytes, int lengthBytes) {
        String lineSeparator = UnsafeUtil.LS;
        long capacity = state.getCapacity();
        UnsafeUtil.checkBounds((long)offsetBytes, (long)lengthBytes, (long)capacity);
        StringBuilder sb = new StringBuilder();
        String uObjStr = "null";
        long uObjHeader = 0L;
        ByteBuffer bb = state.getByteBuffer();
        String bbStr = bb == null ? "null" : bb.getClass().getSimpleName() + ", " + ((long)bb.hashCode() & 0xFFFFFFFFL);
        MemoryRequestServer memReqSvr = state.getMemoryRequestServer();
        String memReqStr = memReqSvr != null ? memReqSvr.getClass().getSimpleName() + ", " + ((long)memReqSvr.hashCode() & 0xFFFFFFFFL) : "null";
        long cumBaseOffset = state.getCumulativeOffset();
        sb.append(preamble).append(lineSeparator);
        sb.append("UnsafeObj, hashCode : ").append(uObjStr).append(lineSeparator);
        sb.append("UnsafeObjHeader     : ").append(uObjHeader).append(lineSeparator);
        sb.append("ByteBuf, hashCode   : ").append(bbStr).append(lineSeparator);
        sb.append("RegionOffset        : ").append(state.getRegionOffset()).append(lineSeparator);
        sb.append("Capacity            : ").append(capacity).append(lineSeparator);
        sb.append("CumBaseOffset       : ").append(cumBaseOffset).append(lineSeparator);
        sb.append("MemReq, hashCode    : ").append(memReqStr).append(lineSeparator);
        sb.append("Valid               : ").append(state.isValid()).append(lineSeparator);
        sb.append("Read Only           : ").append(state.isReadOnly()).append(lineSeparator);
        sb.append("Type Byte Order     : ").append(state.getTypeByteOrder()).append(lineSeparator);
        sb.append("Native Byte Order   : ").append(ByteOrder.nativeOrder()).append(lineSeparator);
        sb.append("JDK Runtime Version : ").append(UnsafeUtil.JDK).append(lineSeparator);
        sb.append("Data, littleEndian  :  0  1  2  3  4  5  6  7");
        for (long i = 0L; i < (long)lengthBytes; ++i) {
            int b = state.getByte(cumBaseOffset + offsetBytes + i) & 0xFF;
            if (i % 8L == 0L) {
                sb.append(StringUtils.format("%n%20s: ", offsetBytes + i));
            }
            sb.append(StringUtils.format("%02x ", b));
        }
        sb.append(lineSeparator);
        return sb.toString();
    }

    static long hash(ByteBuffer memory, long cumOffsetBytes, long lengthBytes, long seed) {
        long hash;
        long remaining = lengthBytes;
        int offset = Ints.checkedCast((long)cumOffsetBytes);
        if (remaining >= 32L) {
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 += memory.getLong(offset) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += memory.getLong(offset + 8) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += memory.getLong(offset + 16) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += memory.getLong(offset + 24) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
                offset += 32;
            } while ((remaining -= 32L) >= 32L);
            hash = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            hash ^= (v1 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            hash ^= (v2 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            hash ^= (v3 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            hash ^= (v4 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
        } else {
            hash = seed + 2870177450012600261L;
        }
        hash += lengthBytes;
        while (remaining >= 8L) {
            long k1 = memory.getLong(offset);
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            hash ^= (k1 *= -7046029288634856825L);
            hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
            offset += 8;
            remaining -= 8L;
        }
        if (remaining >= 4L) {
            hash ^= ((long)memory.getInt(offset) & 0xFFFFFFFFL) * -7046029288634856825L;
            hash = Long.rotateLeft(hash, 23) * -4417276706812531889L + 1609587929392839161L;
            offset += 4;
            remaining -= 4L;
        }
        while (remaining != 0L) {
            hash ^= ((long)memory.get(offset) & 0xFFL) * 2870177450012600261L;
            hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
            --remaining;
            ++offset;
        }
        hash ^= hash >>> 33;
        hash *= -4417276706812531889L;
        hash ^= hash >>> 29;
        hash *= 1609587929392839161L;
        hash ^= hash >>> 32;
        return hash;
    }

    private static class HeapByteBufferMemoryRequestServer
    implements MemoryRequestServer {
        private HeapByteBufferMemoryRequestServer() {
        }

        public WritableMemory request(WritableMemory currentWritableMemory, long capacityBytes) {
            ByteBuffer newBuffer = ByteBuffer.allocate(Ints.checkedCast((long)capacityBytes));
            newBuffer.order(currentWritableMemory.getTypeByteOrder());
            return new SafeWritableMemory(newBuffer);
        }

        public void requestClose(WritableMemory memToClose, WritableMemory newMemory) {
        }
    }
}

