/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.projections;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.projections.BaseTableProjectionSchema;
import org.apache.druid.utils.CollectionUtils;

public class RollupTableProjectionSchema
implements BaseTableProjectionSchema {
    public static final String TYPE_NAME = "base-table-rollup";
    private final VirtualColumns virtualColumns;
    private final List<String> groupingColumns;
    @Nullable
    private final AggregatorFactory[] aggregators;
    private final List<OrderBy> ordering;
    private final int timeColumnPosition;
    private final Granularity effectiveGranularity;

    public static RollupTableProjectionSchema fromMetadata(List<String> dims, Metadata metadata) {
        return new RollupTableProjectionSchema(VirtualColumns.create(Granularities.toVirtualColumn(metadata.getQueryGranularity(), "__virtualGranularity")), dims, metadata.getAggregators(), metadata.getOrdering());
    }

    @JsonCreator
    public RollupTableProjectionSchema(@JsonProperty(value="virtualColumns") VirtualColumns virtualColumns, @JsonProperty(value="groupingColumns") List<String> groupingColumns, @JsonProperty(value="aggregators") @Nullable AggregatorFactory[] aggregators, @JsonProperty(value="ordering") List<OrderBy> ordering) {
        if (CollectionUtils.isNullOrEmpty(groupingColumns)) {
            throw DruidException.defensive("base table projection schema groupingColumns must not be null or empty", new Object[0]);
        }
        if (ordering == null) {
            throw DruidException.defensive("base table projection schema ordering must not be null", new Object[0]);
        }
        this.virtualColumns = virtualColumns == null ? VirtualColumns.EMPTY : virtualColumns;
        this.groupingColumns = groupingColumns;
        this.aggregators = aggregators == null ? new AggregatorFactory[]{} : aggregators;
        this.ordering = ordering;
        int foundTimePosition = -1;
        Granularity granularity = null;
        for (int i = 0; i < ordering.size(); ++i) {
            OrderBy orderBy = ordering.get(i);
            if (!orderBy.getColumnName().equals("__time")) continue;
            foundTimePosition = i;
            VirtualColumn vc = this.virtualColumns.getVirtualColumn("__virtualGranularity");
            granularity = vc != null ? Granularities.fromVirtualColumn(vc) : Granularities.NONE;
        }
        if (granularity == null) {
            throw DruidException.defensive("base table doesn't have a [%s] column?", "__time");
        }
        this.timeColumnPosition = foundTimePosition;
        this.effectiveGranularity = granularity;
    }

    @Override
    @JsonIgnore
    public List<String> getColumnNames() {
        ArrayList<String> columns = new ArrayList<String>(this.groupingColumns.size() + this.aggregators.length);
        columns.addAll(this.groupingColumns);
        for (AggregatorFactory aggregator : this.aggregators) {
            columns.add(aggregator.getName());
        }
        return columns;
    }

    @Override
    @JsonProperty
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<String> getGroupingColumns() {
        return this.groupingColumns;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @Override
    @JsonIgnore
    public int getTimeColumnPosition() {
        return this.timeColumnPosition;
    }

    @Override
    @JsonIgnore
    public Granularity getEffectiveGranularity() {
        return this.effectiveGranularity;
    }

    @Override
    @JsonProperty
    public List<OrderBy> getOrdering() {
        return this.ordering;
    }

    @Override
    @JsonIgnore
    public List<String> getDimensionNames() {
        if (this.timeColumnPosition == 0) {
            return this.groupingColumns.subList(1, this.groupingColumns.size());
        }
        ArrayList dimsWithoutTime = Lists.newArrayListWithCapacity((int)(this.groupingColumns.size() - 1));
        for (String column : this.groupingColumns) {
            if ("__time".equals(column)) continue;
            dimsWithoutTime.add(column);
        }
        return dimsWithoutTime;
    }

    @Override
    public Metadata asMetadata(@Nullable List<AggregateProjectionMetadata> projections) {
        return new Metadata(null, this.aggregators, null, this.effectiveGranularity, true, this.ordering, projections);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollupTableProjectionSchema that = (RollupTableProjectionSchema)o;
        return Objects.equals(this.virtualColumns, that.virtualColumns) && Objects.equals(this.groupingColumns, that.groupingColumns) && Objects.deepEquals(this.aggregators, that.aggregators) && Objects.equals(this.ordering, that.ordering);
    }

    public int hashCode() {
        return Objects.hash(this.virtualColumns, this.groupingColumns, Arrays.hashCode(this.aggregators), this.ordering);
    }

    public String toString() {
        return "RollupTableProjectionSchema{virtualColumns=" + String.valueOf(this.virtualColumns) + ", groupingColumns=" + String.valueOf(this.groupingColumns) + ", aggregators=" + Arrays.toString(this.aggregators) + ", ordering=" + String.valueOf(this.ordering) + "}";
    }
}

