/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.RegisterImageRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RegisterImageRequestMarshaller
implements Marshaller<Request<RegisterImageRequest>, RegisterImageRequest> {
    public Request<RegisterImageRequest> marshall(RegisterImageRequest registerImageRequest) {
        SdkInternalList registerImageRequestTagSpecificationsList;
        SdkInternalList registerImageRequestBillingProductsList;
        SdkInternalList registerImageRequestBlockDeviceMappingsList;
        if (registerImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerImageRequest, "AmazonEC2");
        request.addParameter("Action", "RegisterImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (registerImageRequest.getImageLocation() != null) {
            request.addParameter("ImageLocation", StringUtils.fromString((String)registerImageRequest.getImageLocation()));
        }
        if (registerImageRequest.getArchitecture() != null) {
            request.addParameter("Architecture", StringUtils.fromString((String)registerImageRequest.getArchitecture()));
        }
        if (!(registerImageRequestBlockDeviceMappingsList = (SdkInternalList)registerImageRequest.getBlockDeviceMappings()).isEmpty() || !registerImageRequestBlockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;
            for (Object registerImageRequestBlockDeviceMappingsListValue : registerImageRequestBlockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getDeviceName()));
                }
                if (((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getVirtualName()));
                }
                if ((ebs = ((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getEbs()) != null) {
                    if (ebs.getDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.getDeleteOnTermination()));
                    }
                    if (ebs.getIops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.getIops()));
                    }
                    if (ebs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.getSnapshotId()));
                    }
                    if (ebs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.getVolumeSize()));
                    }
                    if (ebs.getVolumeType() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.getVolumeType()));
                    }
                    if (ebs.getKmsKeyId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringUtils.fromString((String)ebs.getKmsKeyId()));
                    }
                    if (ebs.getThroughput() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Throughput", StringUtils.fromInteger((Integer)ebs.getThroughput()));
                    }
                    if (ebs.getOutpostArn() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.OutpostArn", StringUtils.fromString((String)ebs.getOutpostArn()));
                    }
                    if (ebs.getEncrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.getEncrypted()));
                    }
                }
                if (((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)((BlockDeviceMapping)registerImageRequestBlockDeviceMappingsListValue).getNoDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (registerImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)registerImageRequest.getDescription()));
        }
        if (registerImageRequest.getEnaSupport() != null) {
            request.addParameter("EnaSupport", StringUtils.fromBoolean((Boolean)registerImageRequest.getEnaSupport()));
        }
        if (registerImageRequest.getKernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString((String)registerImageRequest.getKernelId()));
        }
        if (registerImageRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)registerImageRequest.getName()));
        }
        if (!(registerImageRequestBillingProductsList = (SdkInternalList)registerImageRequest.getBillingProducts()).isEmpty() || !registerImageRequestBillingProductsList.isAutoConstruct()) {
            int billingProductsListIndex = 1;
            for (String registerImageRequestBillingProductsListValue : registerImageRequestBillingProductsList) {
                if (registerImageRequestBillingProductsListValue != null) {
                    request.addParameter("BillingProduct." + billingProductsListIndex, StringUtils.fromString((String)registerImageRequestBillingProductsListValue));
                }
                ++billingProductsListIndex;
            }
        }
        if (registerImageRequest.getRamdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString((String)registerImageRequest.getRamdiskId()));
        }
        if (registerImageRequest.getRootDeviceName() != null) {
            request.addParameter("RootDeviceName", StringUtils.fromString((String)registerImageRequest.getRootDeviceName()));
        }
        if (registerImageRequest.getSriovNetSupport() != null) {
            request.addParameter("SriovNetSupport", StringUtils.fromString((String)registerImageRequest.getSriovNetSupport()));
        }
        if (registerImageRequest.getVirtualizationType() != null) {
            request.addParameter("VirtualizationType", StringUtils.fromString((String)registerImageRequest.getVirtualizationType()));
        }
        if (registerImageRequest.getBootMode() != null) {
            request.addParameter("BootMode", StringUtils.fromString((String)registerImageRequest.getBootMode()));
        }
        if (registerImageRequest.getTpmSupport() != null) {
            request.addParameter("TpmSupport", StringUtils.fromString((String)registerImageRequest.getTpmSupport()));
        }
        if (registerImageRequest.getUefiData() != null) {
            request.addParameter("UefiData", StringUtils.fromString((String)registerImageRequest.getUefiData()));
        }
        if (registerImageRequest.getImdsSupport() != null) {
            request.addParameter("ImdsSupport", StringUtils.fromString((String)registerImageRequest.getImdsSupport()));
        }
        if (!(registerImageRequestTagSpecificationsList = (SdkInternalList)registerImageRequest.getTagSpecifications()).isEmpty() || !registerImageRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification registerImageRequestTagSpecificationsListValue : registerImageRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (registerImageRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)registerImageRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)registerImageRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

