/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.metrics.MetricsSystem;
import org.apache.calcite.avatica.metrics.Timer;
import org.apache.calcite.avatica.metrics.noop.NoopMetricsSystem;
import org.apache.calcite.avatica.remote.Handler;
import org.apache.calcite.avatica.remote.MetricsHelper;
import org.apache.calcite.avatica.remote.ProtobufHandler;
import org.apache.calcite.avatica.remote.ProtobufTranslation;
import org.apache.calcite.avatica.remote.ProtobufTranslationImpl;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AbstractAvaticaHandler;
import org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import org.apache.calcite.avatica.server.BadRequestException;
import org.apache.calcite.avatica.server.RemoteUserDisallowedException;
import org.apache.calcite.avatica.server.RemoteUserExtractionException;
import org.apache.calcite.avatica.util.UnsynchronizedBuffer;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvaticaProtobufHandler
extends AbstractAvaticaHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaProtobufHandler.class);
    private final Service service;
    private final ProtobufHandler pbHandler;
    private final ProtobufTranslation protobufTranslation;
    private final MetricsSystem metrics;
    private final Timer requestTimer;
    private final AvaticaServerConfiguration serverConfig;
    final ThreadLocal<UnsynchronizedBuffer> threadLocalBuffer;

    public AvaticaProtobufHandler(Service service) {
        this(service, (MetricsSystem)NoopMetricsSystem.getInstance());
    }

    public AvaticaProtobufHandler(Service service, MetricsSystem metrics) {
        this(service, metrics, null);
    }

    public AvaticaProtobufHandler(Service service, MetricsSystem metrics, AvaticaServerConfiguration serverConfig) {
        this.service = Objects.requireNonNull(service);
        this.metrics = Objects.requireNonNull(metrics);
        this.requestTimer = this.metrics.getTimer(MetricsHelper.concat(AvaticaProtobufHandler.class, (String)"Handler.RequestTimings"));
        this.protobufTranslation = new ProtobufTranslationImpl();
        this.pbHandler = new ProtobufHandler(service, this.protobufTranslation, metrics);
        this.threadLocalBuffer = new ThreadLocal<UnsynchronizedBuffer>(){

            @Override
            public UnsynchronizedBuffer initialValue() {
                return new UnsynchronizedBuffer();
            }
        };
        this.serverConfig = serverConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try (Timer.Context ctx = this.requestTimer.start();){
            Handler.HandlerResponse<byte[]> handlerResponse;
            byte[] requestBytes;
            if (!request.getMethod().equals("POST")) {
                response.setStatus(400);
                response.getOutputStream().write("This server expects only POST calls.".getBytes(StandardCharsets.UTF_8));
                baseRequest.setHandled(true);
                return;
            }
            if (!this.isUserPermitted(this.serverConfig, baseRequest, request, response)) {
                LOG.debug("HTTP request from {} is unauthenticated and authentication is required", (Object)request.getRemoteAddr());
                return;
            }
            UnsynchronizedBuffer buffer = this.threadLocalBuffer.get();
            try (ServletInputStream inputStream = request.getInputStream();){
                requestBytes = AvaticaUtils.readFullyToBytes((InputStream)inputStream, (UnsynchronizedBuffer)buffer);
            }
            finally {
                buffer.reset();
            }
            response.setContentType("application/octet-stream;charset=utf-8");
            response.setStatus(200);
            try {
                if (null != this.serverConfig && this.serverConfig.supportsImpersonation()) {
                    String remoteUser = this.serverConfig.getRemoteUserExtractor().extract(request);
                    handlerResponse = this.serverConfig.doAsRemoteUser(remoteUser, request.getRemoteAddr(), new Callable<Handler.HandlerResponse<byte[]>>(){

                        @Override
                        public Handler.HandlerResponse<byte[]> call() {
                            return AvaticaProtobufHandler.this.pbHandler.apply(requestBytes);
                        }
                    });
                } else {
                    handlerResponse = this.pbHandler.apply(requestBytes);
                }
            }
            catch (RemoteUserExtractionException e) {
                LOG.debug("Failed to extract remote user from request", (Throwable)e);
                handlerResponse = this.pbHandler.unauthenticatedErrorResponse((Exception)e);
            }
            catch (RemoteUserDisallowedException e) {
                LOG.debug("Remote user is not authorized", (Throwable)e);
                handlerResponse = this.pbHandler.unauthorizedErrorResponse((Exception)e);
            }
            catch (BadRequestException e) {
                LOG.debug("Bad request exception", (Throwable)e);
                handlerResponse = this.pbHandler.badRequestErrorResponse((Exception)e);
            }
            catch (Exception e) {
                LOG.debug("Error invoking request from {}", (Object)baseRequest.getRemoteAddr(), (Object)e);
                handlerResponse = this.pbHandler.convertToErrorResponse(e);
            }
            baseRequest.setHandled(true);
            response.setStatus(handlerResponse.getStatusCode());
            response.getOutputStream().write((byte[])handlerResponse.getResponse());
        }
    }

    @Override
    public void setServerRpcMetadata(Service.RpcMetadataResponse metadata) {
        this.service.setRpcMetadata(metadata);
        this.pbHandler.setRpcMetadata(metadata);
    }

    @Override
    public MetricsSystem getMetrics() {
        return this.metrics;
    }
}

