/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.sync;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.druid.catalog.MetadataCatalog;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.SchemaRegistry;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.sync.CatalogSource;

public class LocalMetadataCatalog
implements MetadataCatalog {
    private final CatalogSource catalog;
    private final SchemaRegistry schemaRegistry;

    @Inject
    public LocalMetadataCatalog(CatalogSource catalog, SchemaRegistry schemaRegistry) {
        this.catalog = catalog;
        this.schemaRegistry = schemaRegistry;
    }

    public TableMetadata getTable(TableId tableId) {
        return this.catalog.table(tableId);
    }

    public ResolvedTable resolveTable(TableId tableId) {
        return this.catalog.resolveTable(tableId);
    }

    public List<TableMetadata> tables(String schemaName) {
        SchemaRegistry.SchemaSpec schema = this.schemaRegistry.schema(schemaName);
        if (schema == null || !schema.writable()) {
            return Collections.emptyList();
        }
        return this.catalog.tablesForSchema(schemaName);
    }

    public Set<String> tableNames(String schemaName) {
        SchemaRegistry.SchemaSpec schema = this.schemaRegistry.schema(schemaName);
        if (schema == null || !schema.writable()) {
            return Collections.emptySet();
        }
        List<TableMetadata> catalogTables = this.catalog.tablesForSchema(schemaName);
        HashSet<String> tables = new HashSet<String>();
        for (TableMetadata table : catalogTables) {
            tables.add(table.id().name());
        }
        return tables;
    }
}

