/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.amazonaws.services.s3.model.MultipartUpload;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.MultipartUtils;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.WriteOperationHelper;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.fs.s3a.auth.delegation.S3ADelegationTokens;
import org.apache.hadoop.fs.s3a.commit.CommitConstants;
import org.apache.hadoop.fs.s3a.impl.DirectoryPolicy;
import org.apache.hadoop.fs.s3a.impl.DirectoryPolicyImpl;
import org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.hadoop.fs.s3a.select.SelectTool;
import org.apache.hadoop.fs.s3a.tools.MarkerTool;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ExitCodeProvider;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"management tools"})
@InterfaceStability.Evolving
public abstract class S3GuardTool
extends Configured
implements Tool,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(S3GuardTool.class);
    private static final String ENTRY_POINT = "s3guard";
    private static final String NAME = "s3guard";
    private static final String COMMON_USAGE = "When possible and not overridden by more specific options, metadata\nrepository information will be inferred from the S3A URL (if provided)\n\nGeneric options supported are:\n  -conf <config file> - specify an application configuration file\n  -D <property=value> - define a value for a given property\n";
    static final List<String> UNSUPPORTED_COMMANDS = Arrays.asList("init", "destroy", "authoritative", "diff", "fsck", "import", "prune", "set-capacity");
    private static final String USAGE = "s3guard [command] [OPTIONS] [s3a://BUCKET]\n\nCommands: \n\tbucket-info - provide/check information about a specific bucket\n\tmarkers - View and manipulate S3 directory markers\n\tselect - make an S3 Select call\n\tuploads - list or abort pending multipart uploads\n";
    private static final String E_UNSUPPORTED = "This command is no longer supported";
    static final int SUCCESS = 0;
    static final int INVALID_ARGUMENT = 40;
    static final int E_USAGE = 42;
    static final int ERROR = -1;
    static final int E_BAD_STATE = 46;
    static final int E_NOT_FOUND = 44;
    static final int E_S3GUARD_UNSUPPORTED = -1;
    @VisibleForTesting
    public static final String WRONG_FILESYSTEM = "Wrong filesystem for ";
    private FileSystem baseFS;
    private S3AFileSystem filesystem;
    private final CommandFormat commandFormat;
    public static final String META_FLAG = "meta";
    public static final String DAYS_FLAG = "days";
    public static final String HOURS_FLAG = "hours";
    public static final String MINUTES_FLAG = "minutes";
    public static final String SECONDS_FLAG = "seconds";
    public static final String AGE_OPTIONS_USAGE = "[-days <days>] [-hours <hours>] [-minutes <minutes>] [-seconds <seconds>]";
    public static final String VERBOSE = "verbose";
    private static S3GuardTool command;

    public abstract String getUsage();

    protected S3GuardTool(Configuration conf, String ... opts) {
        super(conf);
        this.commandFormat = new CommandFormat(0, Integer.MAX_VALUE, opts);
    }

    public abstract String getName();

    @Override
    public void close() throws IOException {
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.baseFS});
        this.baseFS = null;
        this.filesystem = null;
    }

    private long getDeltaComponent(TimeUnit unit, String arg) {
        String raw = this.getCommandFormat().getOptValue(arg);
        if (raw == null || raw.isEmpty()) {
            return 0L;
        }
        Long parsed = Long.parseLong(raw);
        return unit.toMillis(parsed);
    }

    long ageOptionsToMsec() {
        long cliDelta = 0L;
        cliDelta += this.getDeltaComponent(TimeUnit.DAYS, DAYS_FLAG);
        cliDelta += this.getDeltaComponent(TimeUnit.HOURS, HOURS_FLAG);
        cliDelta += this.getDeltaComponent(TimeUnit.MINUTES, MINUTES_FLAG);
        return cliDelta += this.getDeltaComponent(TimeUnit.SECONDS, SECONDS_FLAG);
    }

    protected void addAgeOptions() {
        CommandFormat format = this.getCommandFormat();
        format.addOptionWithValue(DAYS_FLAG);
        format.addOptionWithValue(HOURS_FLAG);
        format.addOptionWithValue(MINUTES_FLAG);
        format.addOptionWithValue(SECONDS_FLAG);
    }

    protected void initS3AFileSystem(String path) throws IOException {
        LOG.debug("Initializing S3A FS to {}", (Object)path);
        URI uri = S3GuardTool.toUri(path);
        this.bindFilesystem(FileSystem.newInstance((URI)uri, (Configuration)this.getConf()));
    }

    protected List<String> parseArgs(String[] args) {
        return this.getCommandFormat().parse(args, 1);
    }

    protected S3AFileSystem getFilesystem() {
        return this.filesystem;
    }

    protected S3AFileSystem bindFilesystem(FileSystem bindingFS) {
        FileSystem fs = bindingFS;
        this.baseFS = bindingFS;
        while (fs instanceof FilterFileSystem) {
            fs = ((FilterFileSystem)fs).getRawFileSystem();
        }
        if (!(fs instanceof S3AFileSystem)) {
            throw new ExitUtil.ExitException(53, "Wrong filesystem for URI " + fs.getUri() + " : " + fs.getClass().getName());
        }
        this.filesystem = (S3AFileSystem)fs;
        return this.filesystem;
    }

    protected void resetBindings() {
        this.filesystem = null;
    }

    protected CommandFormat getCommandFormat() {
        return this.commandFormat;
    }

    public final int run(String[] args) throws Exception {
        return this.run(args, System.out);
    }

    public abstract int run(String[] var1, PrintStream var2) throws Exception, ExitUtil.ExitException;

    protected void dumpFileSystemStatistics(PrintStream stream) {
        S3AFileSystem fs = this.getFilesystem();
        if (fs == null) {
            return;
        }
        S3GuardTool.println(stream, "%nIO Statistics for %s%n", fs.getUri());
        IOStatistics iostats = IOStatisticsSupport.retrieveIOStatistics((Object)fs);
        if (iostats != null) {
            S3GuardTool.println(stream, IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)iostats), new Object[0]);
        } else {
            S3GuardTool.println(stream, "FileSystem does not provide IOStatistics", new Object[0]);
        }
        S3GuardTool.println(stream, "", new Object[0]);
    }

    protected static URI toUri(String s3Path) {
        URI uri;
        try {
            uri = new URI(s3Path);
        }
        catch (URISyntaxException e) {
            throw S3GuardTool.invalidArgs("Not a valid filesystem path: %s", s3Path);
        }
        return uri;
    }

    private static void printHelp() {
        if (command == null) {
            S3GuardTool.errorln("Usage: hadoop s3guard [command] [OPTIONS] [s3a://BUCKET]\n\nCommands: \n\tbucket-info - provide/check information about a specific bucket\n\tmarkers - View and manipulate S3 directory markers\n\tselect - make an S3 Select call\n\tuploads - list or abort pending multipart uploads\n");
            S3GuardTool.errorln("\tperform S3A connector administrative commands.");
        } else {
            S3GuardTool.errorln("Usage: hadoop s3guard" + command.getUsage());
        }
        S3GuardTool.errorln();
        S3GuardTool.errorln(COMMON_USAGE);
    }

    protected static void errorln() {
        System.err.println();
    }

    protected static void errorln(String x) {
        System.err.println(x);
    }

    protected static void println(PrintStream out, String format, Object ... args) {
        out.println(String.format(format, args));
    }

    protected static ExitUtil.ExitException notFound(FileNotFoundException e) {
        return new ExitUtil.ExitException(44, e.toString(), (Throwable)e);
    }

    protected static ExitUtil.ExitException invalidArgs(String format, Object ... args) {
        return S3GuardTool.exitException(40, format, args);
    }

    protected static ExitUtil.ExitException badState(String format, Object ... args) {
        return S3GuardTool.exitException(46, format, args);
    }

    protected static ExitUtil.ExitException s3guardUnsupported() {
        throw S3GuardTool.exitException(-1, E_UNSUPPORTED, new Object[0]);
    }

    protected static ExitUtil.ExitException userAborted(String format, Object ... args) {
        return S3GuardTool.exitException(-1, format, args);
    }

    protected static ExitUtil.ExitException exitException(int exitCode, String format, Object ... args) {
        return new ExitUtil.ExitException(exitCode, String.format(format, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(Configuration conf, String ... args) throws Exception {
        int n;
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length == 0) {
            S3GuardTool.printHelp();
            throw new ExitUtil.ExitException(42, "No arguments provided");
        }
        String subCommand = otherArgs[0];
        LOG.debug("Executing command {}", (Object)subCommand);
        if (UNSUPPORTED_COMMANDS.contains(subCommand)) {
            throw S3GuardTool.s3guardUnsupported();
        }
        switch (subCommand) {
            case "bucket-info": {
                command = new BucketInfo(conf);
                break;
            }
            case "markers": {
                command = new MarkerTool(conf);
                break;
            }
            case "uploads": {
                command = new Uploads(conf);
                break;
            }
            case "select": {
                command = new SelectTool(conf);
                break;
            }
            default: {
                S3GuardTool.printHelp();
                throw new ExitUtil.ExitException(42, "Unknown command " + subCommand);
            }
        }
        try {
            n = ToolRunner.run((Configuration)conf, (Tool)command, (String[])otherArgs);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{command});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{command});
        return n;
    }

    public static void main(String[] args) {
        try {
            int ret = S3GuardTool.run(new Configuration(), args);
            S3GuardTool.exit(ret, "");
        }
        catch (CommandFormat.UnknownOptionException e) {
            S3GuardTool.errorln(e.getMessage());
            S3GuardTool.printHelp();
            S3GuardTool.exit(42, e.getMessage());
        }
        catch (ExitUtil.ExitException e) {
            LOG.debug("Exception raised", (Throwable)e);
            S3GuardTool.exit(e.getExitCode(), e.toString());
        }
        catch (FileNotFoundException e) {
            S3GuardTool.errorln(e.toString());
            LOG.debug("Not found:", (Throwable)e);
            S3GuardTool.exit(44, e.toString());
        }
        catch (Throwable e) {
            if (e instanceof ExitCodeProvider) {
                ExitCodeProvider ec = (ExitCodeProvider)e;
                LOG.debug("Exception raised", e);
                S3GuardTool.exit(ec.getExitCode(), e.toString());
            }
            e.printStackTrace(System.err);
            S3GuardTool.exit(-1, e.toString());
        }
    }

    protected static void exit(int status, String text) {
        ExitUtil.terminate((int)status, (String)text);
    }

    static class Uploads
    extends S3GuardTool {
        public static final String NAME = "uploads";
        public static final String ABORT = "abort";
        public static final String LIST = "list";
        public static final String EXPECT = "expect";
        public static final String FORCE = "force";
        public static final String PURPOSE = "list or abort pending multipart uploads";
        private static final String USAGE = "uploads [OPTIONS] s3a://BUCKET[/path]\n\tlist or abort pending multipart uploads\n\nCommon options:\n (-list | -expect <num-uploads> | -abort) [-verbose] [<age-options>] [-force]\n\t - Under given path, list or delete all uploads, or only those \nolder than specified by <age-options>\n<age-options> are any combination of the integer-valued options:\n\t[-days <days>] [-hours <hours>] [-minutes <minutes>] [-seconds <seconds>]\n-expect is similar to list, except no output is printed,\n\tbut the exit code will be an error if the provided number\n\tis different that the number of uploads found by the command.\n-force option prevents the \"Are you sure\" prompt when\n\tusing -abort";
        public static final String TOTAL = "Total";
        private Mode mode = null;
        private int expectedCount;
        private long ageMsec = 0L;
        private boolean verbose = false;
        private boolean force = false;
        private String prefix;

        Uploads(Configuration conf) {
            super(conf, ABORT, LIST, S3GuardTool.VERBOSE, FORCE);
            this.addAgeOptions();
            this.getCommandFormat().addOptionWithValue(EXPECT);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public String getUsage() {
            return USAGE;
        }

        @Override
        public int run(String[] args, PrintStream out) throws InterruptedException, IOException {
            List<String> paths = this.parseArgs(args);
            if (paths.isEmpty()) {
                Uploads.errorln(this.getUsage());
                throw Uploads.invalidArgs("No options specified", new Object[0]);
            }
            this.processArgs(paths, out);
            Uploads.println(out, "Listing uploads under path \"%s\"", this.prefix);
            this.promptBeforeAbort(out);
            this.processUploads(out);
            if (this.verbose) {
                this.dumpFileSystemStatistics(out);
            }
            out.flush();
            return 0;
        }

        private void promptBeforeAbort(PrintStream out) throws IOException {
            if (this.mode != Mode.ABORT || this.force) {
                return;
            }
            Scanner scanner = new Scanner(System.in, "UTF-8");
            out.println("Are you sure you want to delete any pending uploads? (yes/no) >");
            String response = scanner.nextLine();
            if (!"yes".equalsIgnoreCase(response)) {
                throw S3GuardTool.userAborted("User did not answer yes, quitting.", new Object[0]);
            }
        }

        private void processUploads(PrintStream out) throws IOException {
            S3AFileSystem fs = this.getFilesystem();
            MultipartUtils.UploadIterator uploads = fs.listUploads(this.prefix);
            AuditSpanS3A span = fs.createSpan("multipart_upload_aborted", this.prefix, null);
            WriteOperationHelper writeOperationHelper = fs.getWriteOperationHelper();
            int count = 0;
            while (uploads.hasNext()) {
                MultipartUpload upload = uploads.next();
                if (!this.olderThan(upload, this.ageMsec)) continue;
                ++count;
                if (this.mode == Mode.ABORT || this.mode == Mode.LIST || this.verbose) {
                    Uploads.println(out, "%s%s %s", this.mode == Mode.ABORT ? "Deleting: " : "", upload.getKey(), upload.getUploadId());
                }
                if (this.mode != Mode.ABORT) continue;
                writeOperationHelper.abortMultipartUpload(upload.getKey(), upload.getUploadId(), true, Invoker.LOG_EVENT);
            }
            span.deactivate();
            if (this.mode != Mode.EXPECT || this.verbose) {
                Uploads.println(out, "%s %d uploads %s.", TOTAL, count, this.mode == Mode.ABORT ? "deleted" : "found");
            }
            if (this.mode == Mode.EXPECT && count != this.expectedCount) {
                throw Uploads.badState("Expected upload count under %s: %d, found %d", this.prefix, this.expectedCount, count);
            }
        }

        private boolean olderThan(MultipartUpload u, long msec) {
            if (msec == 0L) {
                return true;
            }
            Date ageDate = new Date(System.currentTimeMillis() - msec);
            return ageDate.compareTo(u.getInitiated()) >= 0;
        }

        private void processArgs(List<String> args, PrintStream out) throws IOException {
            String expectVal;
            CommandFormat commands = this.getCommandFormat();
            String err = "Can only specify one of -list,  -abort, and expect";
            if (commands.getOpt(LIST)) {
                this.mode = Mode.LIST;
            }
            if (commands.getOpt(ABORT)) {
                if (this.mode != null) {
                    throw Uploads.invalidArgs(err, new Object[0]);
                }
                this.mode = Mode.ABORT;
            }
            if ((expectVal = commands.getOptValue(EXPECT)) != null) {
                if (this.mode != null) {
                    throw Uploads.invalidArgs(err, new Object[0]);
                }
                this.mode = Mode.EXPECT;
                this.expectedCount = Integer.parseInt(expectVal);
            }
            if (this.mode == null) {
                this.vprintln(out, "No mode specified, defaulting to -list", new Object[0]);
                this.mode = Mode.LIST;
            }
            if (commands.getOpt(S3GuardTool.VERBOSE)) {
                this.verbose = true;
            }
            if (commands.getOpt(FORCE)) {
                this.force = true;
            }
            this.ageMsec = this.ageOptionsToMsec();
            String s3Path = args.get(0);
            URI uri = S3GuardTool.toUri(s3Path);
            this.prefix = uri.getPath();
            if (this.prefix.length() > 0) {
                this.prefix = this.prefix.substring(1);
            }
            this.vprintln(out, "Command: %s, age %d msec, path %s (prefix \"%s\")", this.mode.name(), this.ageMsec, s3Path, this.prefix);
            this.initS3AFileSystem(s3Path);
        }

        private void vprintln(PrintStream out, String format, Object ... args) {
            if (this.verbose) {
                out.println(String.format(format, args));
            }
        }

        private static enum Mode {
            LIST,
            EXPECT,
            ABORT;

        }
    }

    public static class BucketInfo
    extends S3GuardTool {
        public static final String BUCKET_INFO = "bucket-info";
        public static final String NAME = "bucket-info";
        public static final String GUARDED_FLAG = "guarded";
        public static final String UNGUARDED_FLAG = "unguarded";
        public static final String AUTH_FLAG = "auth";
        public static final String NONAUTH_FLAG = "nonauth";
        public static final String ENCRYPTION_FLAG = "encryption";
        public static final String MAGIC_FLAG = "magic";
        public static final String MARKERS_FLAG = "markers";
        public static final String MARKERS_AWARE = "aware";
        public static final String PURPOSE = "provide/check information about a specific bucket";
        private static final String USAGE = "bucket-info [OPTIONS] s3a://BUCKET\n\tprovide/check information about a specific bucket\n\nCommon options:\n  -auth - Require the S3Guard mode to be \"authoritative\"\n  -nonauth - Require the S3Guard mode to be \"non-authoritative\"\n  -magic - Require the S3 filesystem to be support the \"magic\" committer\n  -encryption (none, sse-s3, sse-kms) - Require encryption policy\n  -markers (aware, keep, delete, authoritative) - directory markers policy\n  -guarded - Require S3Guard. Will always fail.\n  -unguarded - Force S3Guard to be disabled (always true)\n";
        @VisibleForTesting
        public static final String LOCATION_UNKNOWN = "Location unknown -caller lacks s3:GetBucketLocation permission";
        @VisibleForTesting
        public static final String IS_MARKER_AWARE = "\tThe S3A connector is compatible with buckets where directory markers are not deleted";

        public BucketInfo(Configuration conf) {
            super(conf, GUARDED_FLAG, UNGUARDED_FLAG, AUTH_FLAG, NONAUTH_FLAG, MAGIC_FLAG);
            CommandFormat format = this.getCommandFormat();
            format.addOptionWithValue(ENCRYPTION_FLAG);
            format.addOptionWithValue(MARKERS_FLAG);
        }

        @Override
        public String getName() {
            return "bucket-info";
        }

        @Override
        public String getUsage() {
            return USAGE;
        }

        @Override
        public int run(String[] args, PrintStream out) throws InterruptedException, IOException {
            List<String> paths = this.parseArgs(args);
            if (paths.isEmpty()) {
                BucketInfo.errorln(this.getUsage());
                throw BucketInfo.invalidArgs("No bucket specified", new Object[0]);
            }
            String s3Path = paths.get(0);
            CommandFormat commands = this.getCommandFormat();
            URI fsURI = BucketInfo.toUri(s3Path);
            S3AFileSystem fs = this.bindFilesystem(FileSystem.newInstance((URI)fsURI, (Configuration)this.getConf()));
            Configuration conf = fs.getConf();
            URI fsUri = fs.getUri();
            BucketInfo.println(out, "Filesystem %s", fsUri);
            try {
                BucketInfo.println(out, "Location: %s", fs.getBucketLocation());
            }
            catch (AccessDeniedException e) {
                LOG.debug("failed to get bucket location", (Throwable)e);
                BucketInfo.println(out, LOCATION_UNKNOWN, new Object[0]);
            }
            Collection<String> authoritativePaths = S3Guard.getAuthoritativePaths(fs);
            if (!authoritativePaths.isEmpty()) {
                BucketInfo.println(out, "Qualified Authoritative Paths:", new Object[0]);
                for (String path : authoritativePaths) {
                    BucketInfo.println(out, "\t%s", path);
                }
                BucketInfo.println(out, "", new Object[0]);
            }
            BucketInfo.println(out, "%nS3A Client", new Object[0]);
            this.printOption(out, "\tSigning Algorithm", "fs.s3a.signing-algorithm", "(unset)");
            String endpoint = conf.getTrimmed("fs.s3a.endpoint", "");
            BucketInfo.println(out, "\tEndpoint: %s=%s", "fs.s3a.endpoint", StringUtils.isNotEmpty((CharSequence)endpoint) ? endpoint : "(unset)");
            String encryption = this.printOption(out, "\tEncryption", "fs.s3a.encryption.algorithm", "none");
            this.printOption(out, "\tInput seek policy", "fs.s3a.experimental.input.fadvise", "default");
            this.printOption(out, "\tChange Detection Source", "fs.s3a.change.detection.source", "etag");
            this.printOption(out, "\tChange Detection Mode", "fs.s3a.change.detection.mode", "server");
            BucketInfo.println(out, "%nS3A Committers", new Object[0]);
            boolean magic = fs.hasPathCapability(new Path(s3Path), "fs.s3a.capability.magic.committer");
            BucketInfo.println(out, "\tThe \"magic\" committer %s supported in the filesystem", magic ? "is" : "is not");
            this.printOption(out, "\tS3A Committer factory class", CommitConstants.S3A_COMMITTER_FACTORY_KEY, "");
            String committer = conf.getTrimmed("fs.s3a.committer.name", "file");
            this.printOption(out, "\tS3A Committer name", "fs.s3a.committer.name", "file");
            switch (committer) {
                case "file": {
                    BucketInfo.println(out, "The original 'file' commmitter is active -this is slow and potentially unsafe", new Object[0]);
                    break;
                }
                case "staging": {
                    BucketInfo.println(out, "The 'staging' committer is used -prefer the 'directory' committer", new Object[0]);
                }
                case "directory": 
                case "partitioned": {
                    this.printOption(out, "\tCluster filesystem staging directory", "fs.s3a.committer.staging.tmp.path", "tmp/staging");
                    this.printOption(out, "\tLocal filesystem buffer directory", "fs.s3a.buffer.dir", "");
                    this.printOption(out, "\tFile conflict resolution", "fs.s3a.committer.staging.conflict-mode", "append");
                    break;
                }
                case "magic": {
                    this.printOption(out, "\tStore magic committer integration", "fs.s3a.committer.magic.enabled", Boolean.toString(true));
                    if (magic) break;
                    BucketInfo.println(out, "Warning: although the magic committer is enabled, the store does not support it", new Object[0]);
                    break;
                }
                default: {
                    BucketInfo.println(out, "\tWarning: committer '%s' is unknown", committer);
                }
            }
            BucketInfo.println(out, "%nSecurity", new Object[0]);
            if (fs.getDelegationTokens().isPresent()) {
                S3ADelegationTokens dtIntegration = fs.getDelegationTokens().get();
                BucketInfo.println(out, "\tDelegation Support enabled: token kind = %s", dtIntegration.getTokenKind());
                UserGroupInformation.AuthenticationMethod authenticationMethod = UserGroupInformation.getCurrentUser().getAuthenticationMethod();
                BucketInfo.println(out, "\tHadoop security mode: %s", authenticationMethod);
                if (UserGroupInformation.isSecurityEnabled()) {
                    BucketInfo.println(out, "\tWarning: security is disabled; tokens will not be collected", new Object[0]);
                }
            } else {
                BucketInfo.println(out, "\tDelegation token support is disabled", new Object[0]);
            }
            if (commands.getOpt(GUARDED_FLAG)) {
                throw BucketInfo.badState("S3Guard is not supported", new Object[0]);
            }
            if (commands.getOpt(MAGIC_FLAG) && !magic) {
                throw BucketInfo.badState("The magic committer is not enabled for %s", fsUri);
            }
            String desiredEncryption = this.getCommandFormat().getOptValue(ENCRYPTION_FLAG);
            if (StringUtils.isNotEmpty((CharSequence)desiredEncryption) && !desiredEncryption.equalsIgnoreCase(encryption)) {
                throw BucketInfo.badState("Bucket %s: required encryption is %s but actual encryption is %s", fsUri, desiredEncryption, encryption);
            }
            this.processMarkerOption(out, fs, this.getCommandFormat().getOptValue(MARKERS_FLAG));
            out.flush();
            return 0;
        }

        private void processMarkerOption(PrintStream out, S3AFileSystem fs, String marker) {
            BucketInfo.println(out, "%nDirectory Markers", new Object[0]);
            DirectoryPolicy markerPolicy = fs.getDirectoryMarkerPolicy();
            String desc = markerPolicy.describe();
            BucketInfo.println(out, "\tThe directory marker policy is \"%s\"", desc);
            String pols = DirectoryPolicyImpl.availablePolicies().stream().map(DirectoryPolicy.MarkerPolicy::getOptionName).collect(Collectors.joining(", "));
            BucketInfo.println(out, "\tAvailable Policies: %s", pols);
            this.printOption(out, "\tAuthoritative paths", "fs.s3a.authoritative.path", "");
            DirectoryPolicy.MarkerPolicy mp = markerPolicy.getMarkerPolicy();
            String desiredMarker = marker == null ? "" : marker.trim();
            String optionName = mp.getOptionName();
            if (!desiredMarker.isEmpty()) {
                if (MARKERS_AWARE.equalsIgnoreCase(desiredMarker)) {
                    BucketInfo.println(out, IS_MARKER_AWARE, new Object[0]);
                } else if (!optionName.equalsIgnoreCase(desiredMarker)) {
                    throw BucketInfo.badState("Bucket %s: required marker policy is \"%s\" but actual policy is \"%s\"", fs.getUri(), desiredMarker, optionName);
                }
            }
        }

        private String printOption(PrintStream out, String description, String key, String defVal) {
            String t = this.getFilesystem().getConf().getTrimmed(key, defVal);
            BucketInfo.println(out, "%s: %s=%s", description, key, t);
            return t;
        }
    }
}

