/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.s3;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.aws.AWSClientConfig;
import org.apache.druid.common.aws.AWSEndpointConfig;
import org.apache.druid.common.aws.AWSProxyConfig;
import org.apache.druid.data.input.InputSourceFactory;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemFields;
import org.apache.druid.data.input.s3.S3InputSource;
import org.apache.druid.data.input.s3.S3InputSourceConfig;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.s3.S3InputDataConfig;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;

public class S3InputSourceFactory
implements InputSourceFactory {
    private final ServerSideEncryptingAmazonS3 s3Client;
    private final ServerSideEncryptingAmazonS3.Builder s3ClientBuilder;
    private final S3InputSourceConfig s3InputSourceConfig;
    private final S3InputDataConfig inputDataConfig;
    private final AWSCredentialsProvider awsCredentialsProvider;
    private final AWSProxyConfig awsProxyConfig;
    private final AWSClientConfig awsClientConfig;
    private final AWSEndpointConfig awsEndpointConfig;

    @JsonCreator
    public S3InputSourceFactory(@JacksonInject ServerSideEncryptingAmazonS3 s3Client, @JacksonInject ServerSideEncryptingAmazonS3.Builder s3ClientBuilder, @JacksonInject S3InputDataConfig inputDataConfig, @JacksonInject AWSCredentialsProvider awsCredentialsProvider, @JsonProperty(value="properties") @Nullable S3InputSourceConfig s3InputSourceConfig, @JsonProperty(value="proxyConfig") @Nullable AWSProxyConfig awsProxyConfig, @JsonProperty(value="endpointConfig") @Nullable AWSEndpointConfig awsEndpointConfig, @JsonProperty(value="clientConfig") @Nullable AWSClientConfig awsClientConfig) {
        this.s3Client = s3Client;
        this.s3ClientBuilder = s3ClientBuilder;
        this.inputDataConfig = inputDataConfig;
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.s3InputSourceConfig = s3InputSourceConfig;
        this.awsProxyConfig = awsProxyConfig;
        this.awsEndpointConfig = awsEndpointConfig;
        this.awsClientConfig = awsClientConfig;
    }

    public SplittableInputSource create(List<String> inputFilePaths) {
        return new S3InputSource(this.s3Client, this.s3ClientBuilder, this.inputDataConfig, this.awsCredentialsProvider, inputFilePaths.stream().map(chosenPath -> {
            try {
                return new URI(StringUtils.replace((String)chosenPath, (String)"s3a://", (String)"s3://"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList()), null, null, null, SystemFields.none(), this.s3InputSourceConfig, this.awsProxyConfig, this.awsEndpointConfig, this.awsClientConfig);
    }

    @Nullable
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public S3InputSourceConfig getS3InputSourceConfig() {
        return this.s3InputSourceConfig;
    }

    @Nullable
    @JsonProperty(value="proxyConfig")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AWSProxyConfig getAwsProxyConfig() {
        return this.awsProxyConfig;
    }

    @Nullable
    @JsonProperty(value="clientConfig")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AWSClientConfig getAwsClientConfig() {
        return this.awsClientConfig;
    }

    @Nullable
    @JsonProperty(value="endpointConfig")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AWSEndpointConfig getAwsEndpointConfig() {
        return this.awsEndpointConfig;
    }
}

