/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexing.common.RetryPolicyConfig;
import org.apache.druid.indexing.common.actions.RemoteTaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;

public class RemoteTaskActionClientFactory
implements TaskActionClientFactory {
    private final ServiceClient overlordClient;
    private final ObjectMapper jsonMapper;

    @Inject
    public RemoteTaskActionClientFactory(@Json ObjectMapper jsonMapper, @EscalatedGlobal ServiceClientFactory clientFactory, @IndexingService ServiceLocator serviceLocator, RetryPolicyConfig retryPolicyConfig) {
        this.overlordClient = clientFactory.makeClient(NodeRole.OVERLORD.toString(), serviceLocator, (ServiceRetryPolicy)RemoteTaskActionClientFactory.buildRetryPolicy(retryPolicyConfig));
        this.jsonMapper = jsonMapper;
    }

    @Override
    public TaskActionClient create(Task task) {
        return new RemoteTaskActionClient(task, this.overlordClient, this.jsonMapper);
    }

    static StandardRetryPolicy buildRetryPolicy(RetryPolicyConfig retryPolicyConfig) {
        return StandardRetryPolicy.builder().maxAttempts(retryPolicyConfig.getMaxRetryCount() + 1L).minWaitMillis(retryPolicyConfig.getMinWait().toStandardDuration().getMillis()).maxWaitMillis(retryPolicyConfig.getMaxWait().toStandardDuration().getMillis()).build();
    }
}

