/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.util.function.Predicate;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.segment.incremental.InputRowFilterResult;

@FunctionalInterface
public interface InputRowFilter {
    public InputRowFilterResult test(InputRow var1);

    public static InputRowFilter fromPredicate(Predicate<InputRow> predicate) {
        return row -> predicate.test(row) ? InputRowFilterResult.ACCEPTED : InputRowFilterResult.CUSTOM_FILTER;
    }

    public static InputRowFilter allowAll() {
        return row -> InputRowFilterResult.ACCEPTED;
    }

    default public InputRowFilter and(InputRowFilter other) {
        return row -> {
            InputRowFilterResult result = this.test(row);
            if (result.isRejected()) {
                return result;
            }
            return other.test(row);
        };
    }
}

