/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.compact;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.ClientCompactionTaskQuery;
import org.apache.druid.client.indexing.ClientTaskQuery;
import org.apache.druid.client.indexing.IndexingTotalWorkerCapacityInfo;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.common.task.CompactionTask;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskQueryTool;
import org.apache.druid.indexing.overlord.TaskQueue;
import org.apache.druid.indexing.overlord.http.TotalWorkerCapacityResponse;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.LockFilterPolicy;
import org.apache.druid.rpc.indexing.NoopOverlordClient;
import org.joda.time.Interval;

class LocalOverlordClient
extends NoopOverlordClient {
    private static final Logger log = new Logger(LocalOverlordClient.class);
    private final TaskMaster taskMaster;
    private final TaskQueryTool taskQueryTool;
    private final ObjectMapper objectMapper;

    LocalOverlordClient(TaskMaster taskMaster, TaskQueryTool taskQueryTool, ObjectMapper objectMapper) {
        this.taskMaster = taskMaster;
        this.taskQueryTool = taskQueryTool;
        this.objectMapper = objectMapper;
    }

    public ListenableFuture<Void> runTask(String taskId, Object clientTaskQuery) {
        CompactionTask task = clientTaskQuery instanceof CompactionTask ? (CompactionTask)clientTaskQuery : this.convertTask(clientTaskQuery, ClientCompactionTaskQuery.class, CompactionTask.class);
        return this.futureOf(() -> {
            this.getValidTaskQueue().add(task);
            return null;
        });
    }

    public ListenableFuture<Void> cancelTask(String taskId) {
        return this.futureOf(() -> {
            this.getValidTaskQueue().shutdown(taskId, "Shutdown by Compaction Scheduler", new Object[0]);
            return null;
        });
    }

    public ListenableFuture<TaskPayloadResponse> taskPayload(String taskId) {
        ClientCompactionTaskQuery taskPayload = (ClientCompactionTaskQuery)this.taskQueryTool.getTask(taskId).transform(task -> this.convertTask(task, CompactionTask.class, ClientCompactionTaskQuery.class)).orNull();
        return this.futureOf(() -> new TaskPayloadResponse(taskId, (ClientTaskQuery)taskPayload));
    }

    public ListenableFuture<CloseableIterator<TaskStatusPlus>> taskStatuses(@Nullable String state, @Nullable String dataSource, @Nullable Integer maxCompletedTasks) {
        ListenableFuture<List> tasksFuture = this.futureOf(this.taskQueryTool::getAllActiveTasks);
        return Futures.transform(tasksFuture, taskList -> CloseableIterators.withEmptyBaggage(taskList.iterator()), (Executor)Execs.directExecutor());
    }

    public ListenableFuture<Map<String, TaskStatus>> taskStatuses(Set<String> taskIds) {
        return this.futureOf(() -> this.taskQueryTool.getMultipleTaskStatuses(taskIds));
    }

    public ListenableFuture<Map<String, List<Interval>>> findLockedIntervals(List<LockFilterPolicy> lockFilterPolicies) {
        return this.futureOf(() -> this.taskQueryTool.getLockedIntervals(lockFilterPolicies));
    }

    public ListenableFuture<IndexingTotalWorkerCapacityInfo> getTotalWorkerCapacity() {
        return this.futureOf(() -> this.convert(this.taskQueryTool.getTotalWorkerCapacity()));
    }

    private TaskQueue getValidTaskQueue() {
        Optional<TaskQueue> taskQueue = this.taskMaster.getTaskQueue();
        if (taskQueue.isPresent()) {
            return (TaskQueue)taskQueue.get();
        }
        throw DruidException.defensive((String)"No TaskQueue. Cannot proceed.", (Object[])new Object[0]);
    }

    private <T> ListenableFuture<T> futureOf(Supplier<T> supplier) {
        try {
            return Futures.immediateFuture(supplier.get());
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    private IndexingTotalWorkerCapacityInfo convert(TotalWorkerCapacityResponse capacity) {
        if (capacity == null) {
            return null;
        }
        return new IndexingTotalWorkerCapacityInfo(capacity.getCurrentClusterCapacity(), capacity.getMaximumCapacityWithAutoScale());
    }

    private <U, V> V convertTask(Object taskPayload, Class<U> inputType, Class<V> outputType) {
        if (taskPayload == null) {
            return null;
        }
        if (!inputType.isInstance(taskPayload)) {
            throw DruidException.defensive((String)"Unknown type[%s] for compaction task. Expected type[%s].", (Object[])new Object[]{taskPayload.getClass().getSimpleName(), inputType.getSimpleName()});
        }
        try {
            return (V)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes(taskPayload), outputType);
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Could not convert task[%s] to client compatible object", new Object[]{taskPayload});
            throw DruidException.defensive((String)"Could not convert task[%s] to compatible object.", (Object[])new Object[]{taskPayload});
        }
    }
}

