/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.sampler;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Row;
import org.joda.time.DateTime;

public class SamplerInputRow
implements InputRow {
    public static final String SAMPLER_ORDERING_COLUMN = "__internal_sampler_order";
    private final InputRow row;
    private final int sortKey;

    public SamplerInputRow(InputRow row, int sortKey) {
        this.row = row;
        this.sortKey = sortKey;
    }

    public List<String> getDimensions() {
        return this.row.getDimensions();
    }

    public long getTimestampFromEpoch() {
        return this.row.getTimestampFromEpoch();
    }

    public DateTime getTimestamp() {
        return this.row.getTimestamp();
    }

    public List<String> getDimension(String dimension) {
        return this.row.getDimension(dimension);
    }

    @Nullable
    public Object getRaw(String dimension) {
        return SAMPLER_ORDERING_COLUMN.equals(dimension) ? Integer.valueOf(this.sortKey) : this.row.getRaw(dimension);
    }

    @Nullable
    public Number getMetric(String metric) {
        return SAMPLER_ORDERING_COLUMN.equals(metric) ? (Number)this.sortKey : (Number)this.row.getMetric(metric);
    }

    public int compareTo(Row o) {
        return this.row.compareTo((Object)o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamplerInputRow that = (SamplerInputRow)o;
        return this.sortKey == that.sortKey && Objects.equals(this.row, that.row);
    }

    public int hashCode() {
        return Objects.hash(this.row, this.sortKey);
    }

    public String toString() {
        return "SamplerInputRow{row=" + String.valueOf(this.row) + "}";
    }
}

