/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.command;

import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.AbstractCommandParser;
import com.github.rvesse.airline.parser.ParseResult;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseException;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.GlobalRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;

public class CliParser<T>
extends AbstractCommandParser<T> {
    public ParseResult<T> parseWithResult(GlobalMetadata<T> metadata, Iterable<String> args) {
        if (args == null) {
            throw new NullPointerException("args cannot be null");
        }
        ParseState<T> state = this.tryParse(metadata, args);
        if (state.getCommand() == null) {
            state = state.getGroup() != null ? state.withCommand(state.getGroup().getDefaultCommand()) : state.withCommand(metadata.getDefaultCommand());
        }
        this.validate(state);
        return metadata.getParserConfiguration().getErrorHandler().finished(state);
    }

    public T parse(GlobalMetadata<T> metadata, Iterable<String> args) {
        ParseResult<T> result = this.parseWithResult(metadata, args);
        return result.getCommand();
    }

    protected void validate(ParseState<T> state) {
        for (GlobalRestriction restriction : state.getGlobal().getRestrictions()) {
            if (restriction == null) continue;
            try {
                restriction.validate(state);
            }
            catch (ParseException e) {
                state.getParserConfiguration().getErrorHandler().handleError(e);
            }
        }
        CommandMetadata command = state.getCommand();
        if (command != null) {
            ArgumentsMetadata arguments = command.getArguments();
            if (arguments != null) {
                for (ArgumentsRestriction restriction : arguments.getRestrictions()) {
                    if (restriction == null) continue;
                    try {
                        restriction.finalValidate(state, arguments);
                    }
                    catch (ParseException e) {
                        state.getParserConfiguration().getErrorHandler().handleError(e);
                    }
                }
            }
            for (OptionMetadata option : command.getAllOptions()) {
                if (option == null) continue;
                for (OptionRestriction restriction : option.getRestrictions()) {
                    if (restriction == null) continue;
                    try {
                        restriction.finalValidate(state, option);
                    }
                    catch (ParseException e) {
                        state.getParserConfiguration().getErrorHandler().handleError(e);
                    }
                }
            }
        }
    }
}

