/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.druid.k8s.overlord.KubernetesTaskRunnerConfig;
import org.joda.time.Period;

public class KubernetesTaskRunnerStaticConfig
implements KubernetesTaskRunnerConfig {
    @JsonProperty
    @NotNull
    private String namespace;
    @JsonProperty
    private String k8sTaskPodNamePrefix = "";
    @JsonProperty
    private String overlordNamespace = "";
    @JsonProperty
    private boolean debugJobs = false;
    @Deprecated
    @JsonProperty
    private boolean sidecarSupport = false;
    @JsonProperty
    private String primaryContainerName = null;
    @JsonProperty
    private String kubexitImage = "karlkfi/kubexit:v0.3.2";
    private Long graceTerminationPeriodSeconds = null;
    @JsonProperty
    private boolean disableClientProxy;
    @JsonProperty
    @NotNull
    private Period maxTaskDuration = new Period((Object)"PT4H");
    @JsonProperty
    @NotNull
    private Period taskCleanupDelay = new Period((Object)"P2D");
    @JsonProperty
    @NotNull
    private Period taskCleanupInterval = new Period((Object)"PT10m");
    @JsonProperty
    @NotNull
    private Period taskJoinTimeout = new Period((Object)"PT1M");
    @JsonProperty
    @NotNull
    private Period k8sjobLaunchTimeout = new Period((Object)"PT1H");
    @JsonProperty
    @NotNull
    private Period logSaveTimeout = new Period((Object)"PT300S");
    @JsonProperty
    private List<String> peonMonitors = ImmutableList.of();
    @JsonProperty
    @NotNull
    private List<String> javaOptsArray = ImmutableList.of();
    @JsonProperty
    @NotNull
    private int cpuCoreInMicro = 0;
    @JsonProperty
    @NotNull
    private Map<String, String> labels = ImmutableMap.of();
    @JsonProperty
    @NotNull
    private Map<String, String> annotations = ImmutableMap.of();
    @JsonProperty
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    @NotNull
    private @Min(value=1L) @Max(value=0x7FFFFFFFL) @NotNull Integer capacity = Integer.MAX_VALUE;
    @JsonProperty
    private boolean useK8sSharedInformers = false;
    @JsonProperty
    private Period k8sSharedInformerResyncPeriod = new Period((Object)"PT5M");

    public KubernetesTaskRunnerStaticConfig() {
    }

    public KubernetesTaskRunnerStaticConfig(@Nonnull String namespace, String overlordNamespace, String k8sTaskPodNamePrefix, boolean debugJobs, boolean sidecarSupport, String primaryContainerName, String kubexitImage, Long graceTerminationPeriodSeconds, boolean disableClientProxy, Period maxTaskDuration, Period taskCleanupDelay, Period taskCleanupInterval, Period k8sjobLaunchTimeout, Period logSaveTimeout, List<String> peonMonitors, List<String> javaOptsArray, int cpuCoreInMicro, Map<String, String> labels, Map<String, String> annotations, Integer capacity, Period taskJoinTimeout, boolean useK8sSharedInformers, Period k8sSharedInformerResyncPeriod) {
        this.namespace = namespace;
        this.overlordNamespace = (String)ObjectUtils.getIfNull((Object)overlordNamespace, (Object)this.overlordNamespace);
        this.k8sTaskPodNamePrefix = k8sTaskPodNamePrefix;
        this.debugJobs = (Boolean)ObjectUtils.getIfNull((Object)debugJobs, (Object)this.debugJobs);
        this.sidecarSupport = (Boolean)ObjectUtils.getIfNull((Object)sidecarSupport, (Object)this.sidecarSupport);
        this.primaryContainerName = (String)ObjectUtils.getIfNull((Object)primaryContainerName, (Object)this.primaryContainerName);
        this.kubexitImage = (String)ObjectUtils.getIfNull((Object)kubexitImage, (Object)this.kubexitImage);
        this.graceTerminationPeriodSeconds = (Long)ObjectUtils.getIfNull((Object)graceTerminationPeriodSeconds, (Object)this.graceTerminationPeriodSeconds);
        this.disableClientProxy = disableClientProxy;
        this.maxTaskDuration = (Period)ObjectUtils.getIfNull((Object)maxTaskDuration, (Object)this.maxTaskDuration);
        this.taskCleanupDelay = (Period)ObjectUtils.getIfNull((Object)taskCleanupDelay, (Object)this.taskCleanupDelay);
        this.taskCleanupInterval = (Period)ObjectUtils.getIfNull((Object)taskCleanupInterval, (Object)this.taskCleanupInterval);
        this.k8sjobLaunchTimeout = (Period)ObjectUtils.getIfNull((Object)k8sjobLaunchTimeout, (Object)this.k8sjobLaunchTimeout);
        this.taskJoinTimeout = (Period)ObjectUtils.getIfNull((Object)taskJoinTimeout, (Object)this.taskJoinTimeout);
        this.logSaveTimeout = (Period)ObjectUtils.getIfNull((Object)logSaveTimeout, (Object)this.logSaveTimeout);
        this.peonMonitors = (List)ObjectUtils.getIfNull(peonMonitors, this.peonMonitors);
        this.javaOptsArray = (List)ObjectUtils.getIfNull(javaOptsArray, this.javaOptsArray);
        this.cpuCoreInMicro = (Integer)ObjectUtils.getIfNull((Object)cpuCoreInMicro, (Object)this.cpuCoreInMicro);
        this.labels = (Map)ObjectUtils.getIfNull(labels, this.labels);
        this.annotations = (Map)ObjectUtils.getIfNull(annotations, this.annotations);
        this.capacity = (Integer)ObjectUtils.getIfNull((Object)capacity, (Object)this.capacity);
        this.useK8sSharedInformers = (Boolean)ObjectUtils.getIfNull((Object)useK8sSharedInformers, (Object)this.useK8sSharedInformers);
        this.k8sSharedInformerResyncPeriod = (Period)ObjectUtils.getIfNull((Object)k8sSharedInformerResyncPeriod, (Object)this.k8sSharedInformerResyncPeriod);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getOverlordNamespace() {
        return this.overlordNamespace;
    }

    @Override
    public String getK8sTaskPodNamePrefix() {
        return this.k8sTaskPodNamePrefix;
    }

    @Override
    public boolean isDebugJobs() {
        return this.debugJobs;
    }

    @Override
    @Deprecated
    public boolean isSidecarSupport() {
        return this.sidecarSupport;
    }

    @Override
    public String getPrimaryContainerName() {
        return this.primaryContainerName;
    }

    @Override
    public String getKubexitImage() {
        return this.kubexitImage;
    }

    @Override
    public Long getGraceTerminationPeriodSeconds() {
        return this.graceTerminationPeriodSeconds;
    }

    @Override
    public boolean isDisableClientProxy() {
        return this.disableClientProxy;
    }

    @Override
    public Period getTaskTimeout() {
        return this.maxTaskDuration;
    }

    @Override
    public Period getTaskJoinTimeout() {
        return this.taskJoinTimeout;
    }

    @Override
    public Period getTaskCleanupDelay() {
        return this.taskCleanupDelay;
    }

    @Override
    public Period getTaskCleanupInterval() {
        return this.taskCleanupInterval;
    }

    @Override
    public Period getTaskLaunchTimeout() {
        return this.k8sjobLaunchTimeout;
    }

    @Override
    public Period getLogSaveTimeout() {
        return this.logSaveTimeout;
    }

    @Override
    public List<String> getPeonMonitors() {
        return this.peonMonitors;
    }

    @Override
    public List<String> getJavaOptsArray() {
        return this.javaOptsArray;
    }

    @Override
    public int getCpuCoreInMicro() {
        return this.cpuCoreInMicro;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Integer getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean isUseK8sSharedInformers() {
        return this.useK8sSharedInformers;
    }

    @Override
    public Period getK8sSharedInformerResyncPeriod() {
        return this.k8sSharedInformerResyncPeriod;
    }
}

