/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.kafkainput;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.data.input.kafka.KafkaRecordEntity;
import org.apache.druid.data.input.kafkainput.KafkaHeaderFormat;
import org.apache.druid.data.input.kafkainput.KafkaInputReader;
import org.apache.druid.indexing.seekablestream.SettableByteEntity;
import org.apache.druid.java.util.common.DateTimes;

public class KafkaInputFormat
implements InputFormat {
    private static final String DEFAULT_HEADER_COLUMN_PREFIX = "kafka.header.";
    private static final String DEFAULT_TIMESTAMP_COLUMN_NAME = "kafka.timestamp";
    private static final String DEFAULT_TOPIC_COLUMN_NAME = "kafka.topic";
    private static final String DEFAULT_PARTITION_COLUMN_NAME = "kafka.partition";
    private static final String DEFAULT_OFFSET_COLUMN_NAME = "kafka.offset";
    private static final String DEFAULT_KEY_COLUMN_NAME = "kafka.key";
    public static final String DEFAULT_AUTO_TIMESTAMP_STRING = "__kif_auto_timestamp";
    private final TimestampSpec dummyTimestampSpec = new TimestampSpec("__kif_auto_timestamp", "auto", DateTimes.EPOCH);
    private final KafkaHeaderFormat headerFormat;
    private final InputFormat valueFormat;
    private final InputFormat keyFormat;
    private final String headerColumnPrefix;
    private final String keyColumnName;
    private final String timestampColumnName;
    private final String topicColumnName;
    private final String partitionColumnName;
    private final String offsetColumnName;

    public KafkaInputFormat(@JsonProperty(value="headerFormat") @Nullable KafkaHeaderFormat headerFormat, @JsonProperty(value="keyFormat") @Nullable InputFormat keyFormat, @JsonProperty(value="valueFormat") InputFormat valueFormat, @JsonProperty(value="headerColumnPrefix") @Nullable String headerColumnPrefix, @JsonProperty(value="keyColumnName") @Nullable String keyColumnName, @JsonProperty(value="timestampColumnName") @Nullable String timestampColumnName, @JsonProperty(value="topicColumnName") @Nullable String topicColumnName, @JsonProperty(value="partitionColumnName") @Nullable String partitionColumnName, @JsonProperty(value="offsetColumnName") @Nullable String offsetColumnName) {
        this.headerFormat = headerFormat;
        this.keyFormat = keyFormat;
        this.valueFormat = (InputFormat)Preconditions.checkNotNull((Object)valueFormat, (Object)"valueFormat must not be null");
        this.headerColumnPrefix = headerColumnPrefix != null ? headerColumnPrefix : DEFAULT_HEADER_COLUMN_PREFIX;
        this.keyColumnName = keyColumnName != null ? keyColumnName : DEFAULT_KEY_COLUMN_NAME;
        this.timestampColumnName = timestampColumnName != null ? timestampColumnName : DEFAULT_TIMESTAMP_COLUMN_NAME;
        this.topicColumnName = topicColumnName != null ? topicColumnName : DEFAULT_TOPIC_COLUMN_NAME;
        this.partitionColumnName = (String)Configs.valueOrDefault((Object)partitionColumnName, (Object)DEFAULT_PARTITION_COLUMN_NAME);
        this.offsetColumnName = (String)Configs.valueOrDefault((Object)offsetColumnName, (Object)DEFAULT_OFFSET_COLUMN_NAME);
    }

    public boolean isSplittable() {
        return false;
    }

    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        SettableByteEntity settableByteEntitySource;
        if (source instanceof SettableByteEntity) {
            settableByteEntitySource = (SettableByteEntity)source;
        } else {
            settableByteEntitySource = new SettableByteEntity();
            settableByteEntitySource.setEntity((ByteEntity)((KafkaRecordEntity)source));
        }
        InputRowSchema newInputRowSchema = new InputRowSchema(this.dummyTimestampSpec, inputRowSchema.getDimensionsSpec(), inputRowSchema.getColumnsFilter(), inputRowSchema.getMetricNames());
        return new KafkaInputReader(inputRowSchema, (SettableByteEntity<KafkaRecordEntity>)settableByteEntitySource, this.headerFormat == null ? null : record -> this.headerFormat.createReader(record.getRecord().headers(), this.headerColumnPrefix), this.keyFormat == null ? null : record -> record.getRecord().key() == null ? null : JsonInputFormat.withLineSplittable((InputFormat)this.keyFormat, (boolean)false).createReader(new InputRowSchema(this.dummyTimestampSpec, DimensionsSpec.builder().useSchemaDiscovery(true).build(), ColumnsFilter.all()), (InputEntity)new ByteEntity((byte[])record.getRecord().key()), temporaryDirectory), JsonInputFormat.withLineSplittable((InputFormat)this.valueFormat, (boolean)false).createReader(newInputRowSchema, source, temporaryDirectory), this.keyColumnName, this.timestampColumnName, this.topicColumnName, this.partitionColumnName, this.offsetColumnName);
    }

    @Nullable
    @JsonProperty
    public KafkaHeaderFormat getHeaderFormat() {
        return this.headerFormat;
    }

    @JsonProperty
    public InputFormat getValueFormat() {
        return this.valueFormat;
    }

    @Nullable
    @JsonProperty
    public InputFormat getKeyFormat() {
        return this.keyFormat;
    }

    @Nullable
    @JsonProperty
    public String getHeaderColumnPrefix() {
        return this.headerColumnPrefix;
    }

    @Nullable
    @JsonProperty
    public String getKeyColumnName() {
        return this.keyColumnName;
    }

    @Nullable
    @JsonProperty
    public String getTimestampColumnName() {
        return this.timestampColumnName;
    }

    @Nullable
    @JsonProperty
    public String getTopicColumnName() {
        return this.topicColumnName;
    }

    @Nullable
    @JsonProperty
    public String getPartitionColumnName() {
        return this.partitionColumnName;
    }

    @Nullable
    @JsonProperty
    public String getOffsetColumnName() {
        return this.offsetColumnName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaInputFormat that = (KafkaInputFormat)o;
        return Objects.equals(this.headerFormat, that.headerFormat) && Objects.equals(this.valueFormat, that.valueFormat) && Objects.equals(this.keyFormat, that.keyFormat) && Objects.equals(this.headerColumnPrefix, that.headerColumnPrefix) && Objects.equals(this.keyColumnName, that.keyColumnName) && Objects.equals(this.timestampColumnName, that.timestampColumnName) && Objects.equals(this.topicColumnName, that.topicColumnName) && Objects.equals(this.partitionColumnName, that.partitionColumnName) && Objects.equals(this.offsetColumnName, that.offsetColumnName);
    }

    public int hashCode() {
        return Objects.hash(this.headerFormat, this.valueFormat, this.keyFormat, this.headerColumnPrefix, this.keyColumnName, this.timestampColumnName, this.topicColumnName, this.partitionColumnName, this.offsetColumnName);
    }
}

