/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.template;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.ClientTaskQuery;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.query.http.ClientSqlQuery;

public class BatchIndexingJob {
    private final boolean isMsq;
    private final ClientSqlQuery msqQuery;
    private final ClientTaskQuery task;

    protected BatchIndexingJob(@Nullable ClientTaskQuery task, @Nullable ClientSqlQuery msqQuery) {
        this.isMsq = task == null;
        this.msqQuery = msqQuery;
        this.task = task;
        InvalidInput.conditionalException((!(task != null && msqQuery != null || task == null && msqQuery == null) ? 1 : 0) != 0, (String)"Exactly one of 'task' or 'msqQuery' must be non-null", (Object[])new Object[0]);
    }

    public ClientSqlQuery getNonNullMsqQuery() {
        return Objects.requireNonNull(this.msqQuery);
    }

    public ClientTaskQuery getNonNullTask() {
        return Objects.requireNonNull(this.task);
    }

    public boolean isMsq() {
        return this.isMsq;
    }

    public String toString() {
        return "BatchIndexingJob{isMsq=" + this.isMsq + ", msqQuery=" + String.valueOf(this.msqQuery) + ", task=" + String.valueOf(this.task) + "}";
    }
}

