/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.messages.client;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.messages.client.MessageRelay;
import org.apache.druid.messages.client.MessageRelayFactory;
import org.apache.druid.server.DruidNode;
import org.apache.druid.utils.CloseableUtils;

@ManageLifecycle
public class MessageRelays<MessageType> {
    private static final Logger log = new Logger(MessageRelays.class);
    @GuardedBy(value="serverRelays")
    private final Map<String, MessageRelay<MessageType>> serverRelays = new HashMap<String, MessageRelay<MessageType>>();
    private final Supplier<DruidNodeDiscovery> discoverySupplier;
    private final MessageRelayFactory<MessageType> messageRelayFactory;
    private final MessageRelaysListener listener;
    private volatile DruidNodeDiscovery discovery;

    public MessageRelays(Supplier<DruidNodeDiscovery> discoverySupplier, MessageRelayFactory<MessageType> messageRelayFactory) {
        this.discoverySupplier = discoverySupplier;
        this.messageRelayFactory = messageRelayFactory;
        this.listener = new MessageRelaysListener();
    }

    @LifecycleStart
    public void start() {
        this.discovery = this.discoverySupplier.get();
        this.discovery.registerListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        if (this.discovery != null) {
            this.discovery.removeListener(this.listener);
            this.discovery = null;
        }
        Map<String, MessageRelay<MessageType>> map = this.serverRelays;
        synchronized (map) {
            try {
                CloseableUtils.closeAll(this.serverRelays.values());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.serverRelays.clear();
            }
        }
    }

    class MessageRelaysListener
    implements DruidNodeDiscovery.Listener {
        MessageRelaysListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodesAdded(Collection<DiscoveryDruidNode> nodes) {
            Map map = MessageRelays.this.serverRelays;
            synchronized (map) {
                for (DiscoveryDruidNode node : nodes) {
                    DruidNode druidNode = node.getDruidNode();
                    MessageRelays.this.serverRelays.computeIfAbsent(druidNode.getHostAndPortToUse(), ignored -> {
                        MessageRelay relay = MessageRelays.this.messageRelayFactory.newRelay(druidNode);
                        relay.start();
                        return relay;
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodesRemoved(Collection<DiscoveryDruidNode> nodes) {
            ArrayList<Pair> removed = new ArrayList<Pair>();
            Map map = MessageRelays.this.serverRelays;
            synchronized (map) {
                for (DiscoveryDruidNode node : nodes) {
                    DruidNode druidNode = node.getDruidNode();
                    String druidHost = druidNode.getHostAndPortToUse();
                    MessageRelay relay = MessageRelays.this.serverRelays.remove(druidHost);
                    if (relay == null) continue;
                    removed.add(Pair.of((Object)druidHost, relay));
                }
            }
            for (Pair relay : removed) {
                try {
                    ((MessageRelay)relay.rhs).close();
                }
                catch (Throwable e) {
                    log.noStackTrace().warn(e, "Could not close relay for server[%s]. Dropping.", new Object[]{relay.lhs});
                }
            }
        }
    }
}

