/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.druid.segment.loading.StorageLocation;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.utils.RuntimeInfo;

public class SegmentLoaderConfig {
    @JacksonInject
    private final RuntimeInfo runtimeInfo = new RuntimeInfo();
    @JsonProperty
    private List<StorageLocationConfig> locations = Collections.emptyList();
    @JsonProperty(value="lazyLoadOnStart")
    private boolean lazyLoadOnStart = false;
    @JsonProperty(value="deleteOnRemove")
    private boolean deleteOnRemove = true;
    @JsonProperty(value="dropSegmentDelayMillis")
    private int dropSegmentDelayMillis = (int)TimeUnit.SECONDS.toMillis(30L);
    @JsonProperty(value="announceIntervalMillis")
    private int announceIntervalMillis = 0;
    @JsonProperty(value="numLoadingThreads")
    private int numLoadingThreads = Math.max(1, this.runtimeInfo.getAvailableProcessors() / 6);
    @JsonProperty(value="numBootstrapThreads")
    private Integer numBootstrapThreads = null;
    @JsonProperty(value="numThreadsToLoadSegmentsIntoPageCacheOnDownload")
    private int numThreadsToLoadSegmentsIntoPageCacheOnDownload = 0;
    @JsonProperty(value="numThreadsToLoadSegmentsIntoPageCacheOnBootstrap")
    private Integer numThreadsToLoadSegmentsIntoPageCacheOnBootstrap = null;
    @JsonProperty
    private File infoDir = null;
    @JsonProperty
    private int statusQueueMaxSize = 100;
    @JsonProperty(value="virtualStorage")
    private boolean virtualStorage = false;
    @JsonProperty(value="virtualStorageLoadThreads")
    private int virtualStorageLoadThreads = 2 * this.runtimeInfo.getAvailableProcessors();
    @JsonProperty(value="virtualStorageIsEphemeral")
    private boolean virtualStorageIsEphemeral = false;
    private long combinedMaxSize = 0L;

    public List<StorageLocationConfig> getLocations() {
        return this.locations;
    }

    public boolean isLazyLoadOnStart() {
        return this.lazyLoadOnStart;
    }

    public boolean isDeleteOnRemove() {
        return this.deleteOnRemove;
    }

    public int getDropSegmentDelayMillis() {
        return this.dropSegmentDelayMillis;
    }

    public int getAnnounceIntervalMillis() {
        return this.announceIntervalMillis;
    }

    public int getNumLoadingThreads() {
        return this.numLoadingThreads;
    }

    public int getNumBootstrapThreads() {
        return this.numBootstrapThreads == null ? this.numLoadingThreads : this.numBootstrapThreads;
    }

    public int getNumThreadsToLoadSegmentsIntoPageCacheOnDownload() {
        return this.numThreadsToLoadSegmentsIntoPageCacheOnDownload;
    }

    public int getNumThreadsToLoadSegmentsIntoPageCacheOnBootstrap() {
        return this.numThreadsToLoadSegmentsIntoPageCacheOnBootstrap == null ? this.numThreadsToLoadSegmentsIntoPageCacheOnDownload : this.numThreadsToLoadSegmentsIntoPageCacheOnBootstrap;
    }

    public File getInfoDir() {
        return this.infoDir;
    }

    public int getStatusQueueMaxSize() {
        return this.statusQueueMaxSize;
    }

    public long getCombinedMaxSize() {
        if (this.combinedMaxSize == 0L) {
            this.combinedMaxSize = this.getLocations().stream().mapToLong(StorageLocationConfig::getMaxSize).sum();
        }
        return this.combinedMaxSize;
    }

    public boolean isVirtualStorage() {
        return this.virtualStorage;
    }

    public int getVirtualStorageLoadThreads() {
        return this.virtualStorageLoadThreads;
    }

    public boolean isVirtualStorageEphemeral() {
        return this.virtualStorageIsEphemeral;
    }

    public SegmentLoaderConfig withLocations(List<StorageLocationConfig> locations) {
        SegmentLoaderConfig retVal = new SegmentLoaderConfig();
        retVal.locations = Lists.newArrayList(locations);
        retVal.deleteOnRemove = this.deleteOnRemove;
        retVal.infoDir = this.infoDir;
        return retVal;
    }

    public SegmentLoaderConfig setVirtualStorage(boolean virtualStorage, boolean virtualStorageFabricEphemeral) {
        this.virtualStorage = virtualStorage;
        this.virtualStorageIsEphemeral = virtualStorageFabricEphemeral;
        return this;
    }

    public List<StorageLocation> toStorageLocations() {
        return this.getLocations().stream().map(locationConfig -> new StorageLocation(locationConfig.getPath(), locationConfig.getMaxSize(), locationConfig.getFreeSpacePercent())).collect(Collectors.toList());
    }

    public String toString() {
        return "SegmentLoaderConfig{locations=" + String.valueOf(this.locations) + ", lazyLoadOnStart=" + this.lazyLoadOnStart + ", deleteOnRemove=" + this.deleteOnRemove + ", dropSegmentDelayMillis=" + this.dropSegmentDelayMillis + ", announceIntervalMillis=" + this.announceIntervalMillis + ", numLoadingThreads=" + this.numLoadingThreads + ", numBootstrapThreads=" + this.numBootstrapThreads + ", numThreadsToLoadSegmentsIntoPageCacheOnDownload=" + this.numThreadsToLoadSegmentsIntoPageCacheOnDownload + ", numThreadsToLoadSegmentsIntoPageCacheOnBootstrap=" + this.numThreadsToLoadSegmentsIntoPageCacheOnBootstrap + ", infoDir=" + String.valueOf(this.infoDir) + ", statusQueueMaxSize=" + this.statusQueueMaxSize + ", virtualStorage=" + this.virtualStorage + ", virtualStorageLoadThreads=" + this.virtualStorageLoadThreads + ", virtualStorageIsEphemeral=" + this.virtualStorageIsEphemeral + ", combinedMaxSize=" + this.combinedMaxSize + "}";
    }
}

