/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.StorageLocationStats;
import org.apache.druid.segment.loading.StorageStats;
import org.apache.druid.segment.loading.VirtualStorageLocationStats;

@LoadScope(roles={"broker", "historical", "indexer", "peon"})
public class StorageMonitor
extends AbstractMonitor {
    public static final String LOCATION_DIMENSION = "location";
    public static final String USED_BYTES = "storage/used/bytes";
    public static final String LOAD_COUNT = "storage/load/count";
    public static final String LOAD_BYTES = "storage/load/bytes";
    public static final String DROP_COUNT = "storage/drop/count";
    public static final String DROP_BYTES = "storage/drop/bytes";
    public static final String VSF_USED_BYTES = "storage/virtual/used/bytes";
    public static final String VSF_HIT_COUNT = "storage/virtual/hit/count";
    public static final String VSF_LOAD_COUNT = "storage/virtual/load/count";
    public static final String VSF_LOAD_BYTES = "storage/virtual/load/bytes";
    public static final String VSF_EVICT_COUNT = "storage/virtual/evict/count";
    public static final String VSF_EVICT_BYTES = "storage/virtual/evict/bytes";
    public static final String VSF_REJECT_COUNT = "storage/virtual/reject/count";
    private final SegmentCacheManager cacheManager;

    @Inject
    public StorageMonitor(SegmentCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        StorageStats stats = this.cacheManager.getStorageStats();
        if (stats != null) {
            ServiceMetricEvent.Builder builder;
            for (Map.Entry<String, StorageLocationStats> entry : stats.getLocationStats().entrySet()) {
                StorageLocationStats staticStats = entry.getValue();
                builder = new ServiceMetricEvent.Builder().setDimension(LOCATION_DIMENSION, (Object)entry.getKey());
                emitter.emit((ServiceEventBuilder)builder.setMetric(USED_BYTES, (Number)staticStats.getUsedBytes()));
                emitter.emit((ServiceEventBuilder)builder.setMetric(LOAD_COUNT, (Number)staticStats.getLoadCount()));
                emitter.emit((ServiceEventBuilder)builder.setMetric(LOAD_BYTES, (Number)staticStats.getLoadBytes()));
                emitter.emit((ServiceEventBuilder)builder.setMetric(DROP_COUNT, (Number)staticStats.getDropCount()));
                emitter.emit((ServiceEventBuilder)builder.setMetric(DROP_BYTES, (Number)staticStats.getDropBytes()));
            }
            for (Map.Entry<String, Object> entry : stats.getVirtualLocationStats().entrySet()) {
                VirtualStorageLocationStats weakStats = (VirtualStorageLocationStats)entry.getValue();
                builder = new ServiceMetricEvent.Builder().setDimension(LOCATION_DIMENSION, (Object)entry.getKey());
                emitter.emit((ServiceEventBuilder)builder.setMetric(VSF_USED_BYTES, (Number)weakStats.getUsedBytes()));
                emitter.emit((ServiceEventBuilder)builder.setMetric(VSF_HIT_COUNT, (Number)weakStats.getHitCount()));
                emitter.emit((ServiceEventBuilder)builder.setMetric(VSF_LOAD_COUNT, (Number)weakStats.getLoadCount()));
                emitter.emit((ServiceEventBuilder)builder.setMetric(VSF_LOAD_BYTES, (Number)weakStats.getLoadBytes()));
                emitter.emit((ServiceEventBuilder)builder.setMetric(VSF_EVICT_COUNT, (Number)weakStats.getEvictionCount()));
                emitter.emit((ServiceEventBuilder)builder.setMetric(VSF_EVICT_BYTES, (Number)weakStats.getEvictionBytes()));
                emitter.emit((ServiceEventBuilder)builder.setMetric(VSF_REJECT_COUNT, (Number)weakStats.getRejectCount()));
            }
        }
        return true;
    }
}

