/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.dart.Dart;
import org.apache.druid.msq.dart.controller.ControllerHolder;
import org.apache.druid.msq.dart.controller.DartControllerContextFactory;
import org.apache.druid.msq.dart.controller.DartControllerRegistry;
import org.apache.druid.msq.dart.controller.QueryInfoAndReport;
import org.apache.druid.msq.dart.controller.http.DartQueryInfo;
import org.apache.druid.msq.dart.controller.sql.DartQueryMaker;
import org.apache.druid.msq.dart.controller.sql.DartSqlClients;
import org.apache.druid.msq.dart.controller.sql.PrePlannedDartQueryMaker;
import org.apache.druid.msq.dart.guice.DartControllerConfig;
import org.apache.druid.msq.exec.QueryKitSpecFactory;
import org.apache.druid.msq.indexing.error.CancellationReason;
import org.apache.druid.msq.querykit.MultiQueryKit;
import org.apache.druid.msq.sql.DartQueryKitSpecFactory;
import org.apache.druid.msq.sql.MSQTaskSqlEngine;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.run.SqlEngines;
import org.apache.druid.sql.destination.IngestDestination;
import org.apache.druid.sql.http.GetQueriesResponse;
import org.apache.druid.sql.http.GetQueryReportResponse;
import org.apache.druid.sql.http.QueryInfo;

@LazySingleton
public class DartSqlEngine
implements SqlEngine {
    public static final String NAME = "msq-dart";
    private static final Logger log = new Logger(DartSqlEngine.class);
    private final DartControllerContextFactory controllerContextFactory;
    private final DartControllerRegistry controllerRegistry;
    private final DartControllerConfig controllerConfig;
    private final ExecutorService controllerExecutor;
    private final ServerConfig serverConfig;
    private final QueryKitSpecFactory queryKitSpecFactory;
    private final MultiQueryKit queryKit;
    private final DefaultQueryConfig dartQueryConfig;
    private final SqlToolbox toolbox;
    private final DartSqlClients sqlClients;

    @Inject
    public DartSqlEngine(DartControllerContextFactory controllerContextFactory, DartControllerRegistry controllerRegistry, DartControllerConfig controllerConfig, DartQueryKitSpecFactory queryKitSpecFactory, MultiQueryKit queryKit, ServerConfig serverConfig, @Dart DefaultQueryConfig dartQueryConfig, SqlToolbox toolbox, DartSqlClients sqlClients) {
        this(controllerContextFactory, controllerRegistry, controllerConfig, Execs.multiThreaded((int)controllerConfig.getConcurrentQueries(), (String)"dart-controller-%s"), queryKitSpecFactory, queryKit, serverConfig, dartQueryConfig, toolbox, sqlClients);
    }

    public DartSqlEngine(DartControllerContextFactory controllerContextFactory, DartControllerRegistry controllerRegistry, DartControllerConfig controllerConfig, ExecutorService controllerExecutor, QueryKitSpecFactory queryKitSpecFactory, MultiQueryKit queryKit, ServerConfig serverConfig, DefaultQueryConfig dartQueryConfig, SqlToolbox toolbox, DartSqlClients sqlClients) {
        this.controllerContextFactory = controllerContextFactory;
        this.controllerRegistry = controllerRegistry;
        this.controllerConfig = controllerConfig;
        this.controllerExecutor = controllerExecutor;
        this.queryKitSpecFactory = queryKitSpecFactory;
        this.queryKit = queryKit;
        this.serverConfig = serverConfig;
        this.dartQueryConfig = dartQueryConfig;
        this.toolbox = toolbox;
        this.sqlClients = sqlClients;
    }

    public String name() {
        return NAME;
    }

    public boolean featureAvailable(EngineFeature feature) {
        switch (feature) {
            case CAN_SELECT: 
            case SCAN_ORDER_BY_NON_TIME: 
            case WINDOW_FUNCTIONS: 
            case WINDOW_LEAF_OPERATOR: 
            case UNNEST: {
                return true;
            }
            case CAN_INSERT: 
            case CAN_REPLACE: 
            case READ_EXTERNAL_DATA: 
            case ALLOW_BINDABLE_PLAN: 
            case ALLOW_BROADCAST_RIGHTY_JOIN: 
            case ALLOW_TOP_LEVEL_UNION_ALL: 
            case TIMESERIES_QUERY: 
            case TOPN_QUERY: 
            case TIME_BOUNDARY_QUERY: 
            case GROUPING_SETS: 
            case GROUPBY_IMPLICITLY_SORTS: {
                return false;
            }
        }
        throw new IAE("Unrecognized feature: %s", new Object[]{feature});
    }

    public void validateContext(Map<String, Object> queryContext) {
        SqlEngines.validateNoSpecialContextKeys(queryContext, MSQTaskSqlEngine.SYSTEM_CONTEXT_PARAMETERS);
    }

    public RelDataType resultTypeForSelect(RelDataTypeFactory typeFactory, RelDataType validatedRowType, Map<String, Object> queryContext) {
        if (QueryContext.of(queryContext).getFullReport()) {
            return typeFactory.createStructType((List)ImmutableList.of((Object)Calcites.createSqlType((RelDataTypeFactory)typeFactory, (SqlTypeName)SqlTypeName.VARCHAR)), (List)ImmutableList.of((Object)"fullReport"));
        }
        return validatedRowType;
    }

    public RelDataType resultTypeForInsert(RelDataTypeFactory typeFactory, RelDataType validatedRowType, Map<String, Object> queryContext) {
        throw DruidException.defensive((String)"Cannot execute DML commands with engine[%s]", (Object[])new Object[]{this.name()});
    }

    public QueryMaker buildQueryMakerForSelect(RelRoot relRoot, PlannerContext plannerContext) {
        DartQueryMaker dartQueryMaker = new DartQueryMaker((List<Map.Entry<Integer, String>>)relRoot.fields, this.controllerContextFactory, plannerContext, this.controllerRegistry, this.controllerConfig, this.controllerExecutor, this.queryKitSpecFactory, this.queryKit, this.serverConfig);
        if (plannerContext.queryContext().isPrePlanned()) {
            return new PrePlannedDartQueryMaker(plannerContext, dartQueryMaker);
        }
        return dartQueryMaker;
    }

    public QueryMaker buildQueryMakerForInsert(IngestDestination destination, RelRoot relRoot, PlannerContext plannerContext) {
        throw DruidException.defensive((String)"Cannot execute DML commands with engine[%s]", (Object[])new Object[]{this.name()});
    }

    public void initContextMap(Map<String, Object> contextMap) {
        for (Map.Entry entry : this.dartQueryConfig.getContext().entrySet()) {
            contextMap.putIfAbsent((String)entry.getKey(), entry.getValue());
        }
        String dartQueryId = UUID.randomUUID().toString();
        contextMap.put("dartQueryId", dartQueryId);
    }

    public SqlStatementFactory getSqlStatementFactory() {
        return new SqlStatementFactory(this.toolbox.withEngine((SqlEngine)this));
    }

    public GetQueriesResponse getRunningQueries(boolean selfOnly, AuthenticationResult authenticationResult, AuthorizationResult stateReadAuthorization) {
        List queries = this.controllerRegistry.getAllControllers().stream().map(DartQueryInfo::fromControllerHolder).collect(Collectors.toList());
        if (!selfOnly) {
            List otherQueries = (List)FutureUtils.getUnchecked((ListenableFuture)Futures.successfulAsList((Iterable)Iterables.transform(this.sqlClients.getAllClients(), client -> client.getRunningQueries(true))), (boolean)true);
            for (GetQueriesResponse response : otherQueries) {
                if (response == null) continue;
                response.getQueries().stream().filter(queryInfo -> queryInfo instanceof DartQueryInfo).map(queryInfo -> (DartQueryInfo)queryInfo).forEach(queries::add);
            }
        }
        queries.sort(Comparator.comparing(DartQueryInfo::getStartTime).thenComparing(DartQueryInfo::getDartQueryId));
        if (stateReadAuthorization.allowAccessWithNoRestriction()) {
            return new GetQueriesResponse(List.copyOf(queries));
        }
        return new GetQueriesResponse(queries.stream().filter(query -> DartSqlEngine.isOwnQuery(authenticationResult, query)).map(DartQueryInfo::withoutAuthenticationResult).collect(Collectors.toList()));
    }

    @Nullable
    public GetQueryReportResponse getQueryReport(String sqlQueryId, boolean selfOnly, AuthenticationResult authenticationResult, AuthorizationResult stateReadAuthorization) {
        QueryInfoAndReport infoAndReport = this.controllerRegistry.getQueryInfoAndReportBySqlQueryId(sqlQueryId);
        if (infoAndReport == null && !selfOnly) {
            List otherReports = (List)FutureUtils.getUnchecked((ListenableFuture)Futures.successfulAsList((Iterable)Iterables.transform(this.sqlClients.getAllClients(), client -> client.getQueryReport(sqlQueryId, true))), (boolean)true);
            for (GetQueryReportResponse otherReport : otherReports) {
                if (otherReport == null || otherReport.getQueryInfo() == null) continue;
                infoAndReport = new QueryInfoAndReport((DartQueryInfo)otherReport.getQueryInfo(), otherReport.getReportMap(), DateTimes.utc((long)0L));
                break;
            }
        }
        if (infoAndReport == null) {
            return null;
        }
        if (stateReadAuthorization.allowAccessWithNoRestriction()) {
            return new GetQueryReportResponse((QueryInfo)infoAndReport.getQueryInfo(), infoAndReport.getReportMap());
        }
        DartQueryInfo queryInfo = infoAndReport.getQueryInfo();
        if (DartSqlEngine.isOwnQuery(authenticationResult, queryInfo)) {
            return new GetQueryReportResponse((QueryInfo)queryInfo.withoutAuthenticationResult(), infoAndReport.getReportMap());
        }
        return null;
    }

    private static boolean isOwnQuery(AuthenticationResult authenticationResult, DartQueryInfo queryInfo) {
        return authenticationResult.getAuthenticatedBy() != null && authenticationResult.getIdentity() != null && Objects.equals(authenticationResult.getAuthenticatedBy(), queryInfo.getAuthenticator()) && Objects.equals(authenticationResult.getIdentity(), queryInfo.getIdentity());
    }

    public void cancelQuery(PlannerContext plannerContext, QueryScheduler queryScheduler) {
        Object dartQueryId = plannerContext.queryContext().get("dartQueryId");
        if (dartQueryId instanceof String) {
            ControllerHolder holder = this.controllerRegistry.getController((String)dartQueryId);
            if (holder != null) {
                holder.cancel(CancellationReason.USER_REQUEST);
            }
        } else {
            log.warn("%s[%s] for query[%s] is not a string, cannot cancel.", new Object[]{"dartQueryId", dartQueryId, plannerContext.getSqlQueryId()});
        }
    }
}

