/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import java.io.Closeable;
import java.io.File;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.messages.server.Outbox;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.msq.dart.worker.DartControllerClient;
import org.apache.druid.msq.dart.worker.DartFrameContext;
import org.apache.druid.msq.dart.worker.DartWorkerClient;
import org.apache.druid.msq.dart.worker.WorkerId;
import org.apache.druid.msq.exec.ControllerClient;
import org.apache.druid.msq.exec.DataServerQueryHandlerFactory;
import org.apache.druid.msq.exec.FrameContext;
import org.apache.druid.msq.exec.FrameWriterSpec;
import org.apache.druid.msq.exec.MSQMetricEventBuilder;
import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.msq.exec.ProcessingBuffersProvider;
import org.apache.druid.msq.exec.ProcessingBuffersSet;
import org.apache.druid.msq.exec.Worker;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.exec.WorkerContext;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.exec.WorkerStorageParameters;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.server.DruidNode;
import org.apache.druid.utils.CloseableUtils;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class DartWorkerContext
implements WorkerContext {
    public static final boolean DEFAULT_LIVE_REPORT_COUNTERS = false;
    private final String queryId;
    private final String controllerHost;
    private final WorkerId workerId;
    private final DruidNode selfNode;
    private final ObjectMapper jsonMapper;
    private final PolicyEnforcer policyEnforcer;
    private final Injector injector;
    private final DartWorkerClient workerClient;
    private final SegmentWrangler segmentWrangler;
    private final GroupingEngine groupingEngine;
    private final DataSegmentProvider dataSegmentProvider;
    private final MemoryIntrospector memoryIntrospector;
    private final ProcessingBuffersProvider processingBuffersProvider;
    private final Outbox<ControllerMessage> outbox;
    private final File tempDir;
    private final QueryContext queryContext;
    private final ServiceEmitter emitter;
    private final int threadCount;
    private volatile @MonotonicNonNull ResourceHolder<ProcessingBuffersSet> processingBuffersSet;
    private final DataServerQueryHandlerFactory dataServerQueryHandlerFactory;

    DartWorkerContext(String queryId, String controllerHost, DruidNode selfNode, ObjectMapper jsonMapper, PolicyEnforcer policyEnforcer, Injector injector, DartWorkerClient workerClient, DruidProcessingConfig processingConfig, SegmentWrangler segmentWrangler, GroupingEngine groupingEngine, DataSegmentProvider dataSegmentProvider, MemoryIntrospector memoryIntrospector, ProcessingBuffersProvider processingBuffersProvider, Outbox<ControllerMessage> outbox, File tempDir, QueryContext queryContext, DataServerQueryHandlerFactory dataServerQueryHandlerFactory, ServiceEmitter emitter) {
        this.queryId = queryId;
        this.controllerHost = controllerHost;
        this.dataServerQueryHandlerFactory = dataServerQueryHandlerFactory;
        this.workerId = WorkerId.fromDruidNode(selfNode, queryId);
        this.selfNode = selfNode;
        this.jsonMapper = jsonMapper;
        this.policyEnforcer = policyEnforcer;
        this.injector = injector;
        this.workerClient = workerClient;
        this.segmentWrangler = segmentWrangler;
        this.groupingEngine = groupingEngine;
        this.dataSegmentProvider = dataSegmentProvider;
        this.memoryIntrospector = memoryIntrospector;
        this.processingBuffersProvider = processingBuffersProvider;
        this.outbox = outbox;
        this.tempDir = tempDir;
        this.queryContext = (QueryContext)Preconditions.checkNotNull((Object)queryContext, (Object)"queryContext");
        this.emitter = emitter;
        int baseThreadCount = processingConfig.getNumThreads();
        Integer maxThreads = MultiStageQueryContext.getMaxThreads(queryContext);
        this.threadCount = maxThreads != null && maxThreads > 0 ? Math.min(baseThreadCount, maxThreads) : baseThreadCount;
    }

    @Override
    public String queryId() {
        return this.queryId;
    }

    @Override
    public String workerId() {
        return this.workerId.toString();
    }

    @Override
    public ObjectMapper jsonMapper() {
        return this.jsonMapper;
    }

    @Override
    public PolicyEnforcer policyEnforcer() {
        return this.policyEnforcer;
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    public void registerWorker(Worker worker, Closer closer) {
    }

    @Override
    public int maxConcurrentStages() {
        int retVal = MultiStageQueryContext.getMaxConcurrentStagesWithDefault(this.queryContext, -1);
        if (retVal <= 0) {
            throw new IAE("Illegal maxConcurrentStages[%s]", new Object[]{retVal});
        }
        return retVal;
    }

    @Override
    public void emitMetric(MSQMetricEventBuilder metricBuilder) {
        metricBuilder.setDartDimensions(this.queryContext);
        metricBuilder.setDimension("dartQueryId", this.queryId());
        this.emitter.emit((ServiceEventBuilder)metricBuilder);
    }

    @Override
    public ControllerClient makeControllerClient() {
        return new DartControllerClient(this.outbox, this.queryId, this.controllerHost, MultiStageQueryContext.getLiveReportCounters(this.queryContext, false));
    }

    @Override
    public WorkerClient makeWorkerClient() {
        return this.workerClient;
    }

    @Override
    public File tempDir() {
        return this.tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FrameContext frameContext(WorkOrder workOrder) {
        if (this.processingBuffersSet == null) {
            DartWorkerContext dartWorkerContext = this;
            synchronized (dartWorkerContext) {
                if (this.processingBuffersSet == null) {
                    this.processingBuffersSet = this.processingBuffersProvider.acquire(workOrder.getQueryDefinition(), this.maxConcurrentStages());
                }
            }
        }
        WorkerMemoryParameters memoryParameters = WorkerMemoryParameters.createProductionInstance(workOrder, this.memoryIntrospector, this.maxConcurrentStages());
        WorkerStorageParameters storageParameters = WorkerStorageParameters.createInstance(-1L, false);
        return new DartFrameContext(workOrder.getStageDefinition().getId(), this, FrameWriterSpec.fromContext(workOrder.getWorkerContext()), this.segmentWrangler, this.groupingEngine, this.dataSegmentProvider, ((ProcessingBuffersSet)this.processingBuffersSet.get()).acquireForStage(workOrder.getStageDefinition()), memoryParameters, storageParameters, this.dataServerQueryHandlerFactory);
    }

    @Override
    public int threadCount() {
        return this.threadCount;
    }

    @Override
    public boolean includeAllCounters() {
        return true;
    }

    @Override
    public DruidNode selfNode() {
        return this.selfNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DartWorkerContext dartWorkerContext = this;
        synchronized (dartWorkerContext) {
            if (this.processingBuffersSet != null) {
                this.processingBuffersSet.close();
                this.processingBuffersSet = null;
            }
        }
        CloseableUtils.closeAndWrapExceptions((Closeable)this.workerClient);
    }
}

